/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.config.SyntaxHighlightingMode;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.fabric.ScreenOverlayImplImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SeparatorMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.common.util.Weather;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1162;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_918;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ScreenOverlayImpl
extends ScreenOverlay {
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static final List<Runnable> AFTER_RENDER = Lists.newArrayList();
    private static final EntryListWidget ENTRY_LIST_WIDGET = new EntryListWidget();
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReload = false;
    public boolean shouldReloadSearch = false;
    private Rectangle screenBounds;
    private Rectangle bounds;
    private class_1041 window;
    private Button leftButton;
    private Button rightButton;
    private Widget configButton;
    private CurrentDraggingStack draggingStack = new CurrentDraggingStack();
    @Nullable
    public DefaultDisplayChoosePageWidget choosePageWidget;
    @Nullable
    private OverlayMenu overlayMenu = null;

    public static EntryListWidget getEntryListWidget() {
        return ENTRY_LIST_WIDGET;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    public static ScreenOverlayImpl getInstance() {
        return (ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get();
    }

    public void tick() {
        if (REIRuntimeImpl.getSearchField() != null) {
            REIRuntimeImpl.getSearchField().tick();
            if (class_310.method_1551().field_1724 != null && !PluginManager.areAnyReloading()) {
                CraftableFilter.INSTANCE.tick();
            }
        }
    }

    public boolean isMenuOpened(UUID uuid) {
        return this.overlayMenu != null && this.overlayMenu.uuid.equals(uuid);
    }

    public boolean isAnyMenuOpened() {
        return this.overlayMenu != null;
    }

    public boolean isMenuInBounds(UUID uuid) {
        return this.isMenuOpened(uuid) && this.overlayMenu.inBounds.test(PointHelper.ofMouse());
    }

    private void proceedOpenMenu(UUID uuid, Runnable runnable) {
        this.proceedOpenMenuOrElse(uuid, runnable, menu -> {});
    }

    private void proceedOpenMenuOrElse(UUID uuid, Runnable runnable, Consumer<OverlayMenu> orElse) {
        if (this.overlayMenu == null || !this.overlayMenu.uuid.equals(uuid)) {
            this.closeOverlayMenu();
            runnable.run();
        } else {
            orElse.accept(this.overlayMenu);
        }
    }

    public void openMenu(UUID uuid, Menu menu) {
        this.openMenu(uuid, menu, point -> false, point -> true);
    }

    public void openMenu(UUID uuid, Menu menu, Predicate<Point> or, Predicate<Point> and) {
        this.overlayMenu = new OverlayMenu(uuid, menu, Widgets.withTranslate(menu, 0.0, 0.0, 400.0), or, and);
    }

    @ApiStatus.Internal
    @Nullable
    public Menu getOverlayMenu() {
        if (this.isMenuOpened(Menu.SUBSETS)) {
            return this.overlayMenu.menu;
        }
        throw new IllegalStateException("Subsets menu accessed when subsets are not opened!");
    }

    @Override
    @ApiStatus.Internal
    public void closeOverlayMenu() {
        OverlayMenu tmpOverlayMenu = this.overlayMenu;
        if (tmpOverlayMenu != null) {
            AFTER_RENDER.add(() -> this.widgets.remove(tmpOverlayMenu.wrappedMenu));
        }
        this.overlayMenu = null;
    }

    @Override
    public void queueReloadOverlay() {
        this.shouldReload = true;
    }

    public void queueReloadSearch() {
        this.shouldReloadSearch = true;
    }

    @Override
    public DraggingContext<?> getDraggingContext() {
        return this.draggingStack;
    }

    protected boolean hasSpace() {
        return !this.bounds.isEmpty();
    }

    public void init(boolean useless) {
        this.init();
    }

    public void init() {
        this.draggingStack.set(DraggableStackProvider.from(() -> ScreenRegistry.getInstance().getDraggableProviders()), DraggableStackVisitor.from(() -> ScreenRegistry.getInstance().getDraggableVisitors()));
        this.shouldReload = false;
        this.shouldReloadSearch = false;
        this.method_25396().clear();
        this.window = class_310.method_1551().method_22683();
        this.screenBounds = ScreenRegistry.getInstance().getScreenBounds(class_310.method_1551().field_1755);
        this.bounds = ScreenOverlayImpl.calculateOverlayBounds();
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            ScreenOverlayImpl.favoritesListWidget.favoritePanel.resetRows();
            this.widgets.add(favoritesListWidget);
        }
        ENTRY_LIST_WIDGET.updateArea(this.bounds, REIRuntimeImpl.getSearchField() == null ? "" : REIRuntimeImpl.getSearchField().getText());
        this.widgets.add(ENTRY_LIST_WIDGET);
        REIRuntimeImpl.getSearchField().getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add(REIRuntimeImpl.getSearchField());
        REIRuntimeImpl.getSearchField().setResponder(s -> ENTRY_LIST_WIDGET.updateSearch((String)s, false));
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.leftButton = Widgets.createButton(new Rectangle(this.bounds.x, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
                ENTRY_LIST_WIDGET.previousPage();
                if (ENTRY_LIST_WIDGET.getPage() < 0) {
                    ENTRY_LIST_WIDGET.setPage(ENTRY_LIST_WIDGET.getTotalPages() - 1);
                }
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLine((class_2561)new class_2588("text.rei.previous_page")).focusable(false);
            this.widgets.add(this.leftButton);
            this.rightButton = Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 18, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
                ENTRY_LIST_WIDGET.nextPage();
                if (ENTRY_LIST_WIDGET.getPage() >= ENTRY_LIST_WIDGET.getTotalPages()) {
                    ENTRY_LIST_WIDGET.setPage(0);
                }
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLine((class_2561)new class_2588("text.rei.next_page")).focusable(false);
            this.widgets.add(this.rightButton);
        }
        Rectangle configButtonArea = this.getConfigButtonArea();
        UUID configButtonUuid = UUID.fromString("4357bc36-0a4e-47d2-8e07-ddc220df4a0f");
        this.configButton = InternalWidgets.wrapLateRenderable(Widgets.withTranslate(InternalWidgets.concatWidgets(Widgets.createButton(configButtonArea, class_333.field_18967).onClick(button -> {
            if (class_437.method_25442() || class_437.method_25441()) {
                ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                return;
            }
            ConfigManager.getInstance().openConfigScreen(REIRuntime.getInstance().getPreviousScreen());
        }).onRender((matrices, button) -> {
            if (ClientHelper.getInstance().isCheating() && !(class_310.method_1551().field_1755 instanceof DisplayScreen) && ClientHelperImpl.getInstance().hasOperatorPermission()) {
                button.setTint(ClientHelperImpl.getInstance().hasPermissionToUsePackets() ? 721354752 : 1476440063);
            } else {
                button.removeTint();
            }
            boolean isOpened = this.isMenuOpened(configButtonUuid);
            if (isOpened || !this.isAnyMenuOpened()) {
                boolean inBounds;
                boolean bl = inBounds = this.isNotInExclusionZones(PointHelper.getMouseFloatingX(), PointHelper.getMouseFloatingY()) && button.containsMouse(PointHelper.ofMouse()) || this.isMenuInBounds(configButtonUuid);
                if (isOpened != inBounds) {
                    if (inBounds) {
                        Menu menu = new Menu(button.getBounds(), this.provideConfigButtonMenu(), false);
                        this.openMenu(configButtonUuid, menu, button::containsMouse, point -> true);
                    } else {
                        this.closeOverlayMenu();
                    }
                }
            }
        }).focusable(false).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipSupplier(button -> {
            ArrayList<Object> tooltips = new ArrayList<Object>();
            tooltips.add(new class_2588("text.rei.config_tooltip"));
            tooltips.add(new ImmutableTextComponent("  "));
            if (!ClientHelper.getInstance().isCheating()) {
                tooltips.add(new class_2588("text.rei.cheating_disabled"));
            } else if (!ClientHelperImpl.getInstance().hasOperatorPermission()) {
                if (this.minecraft.field_1761.method_2914()) {
                    tooltips.add(new class_2588("text.rei.cheating_limited_creative_enabled"));
                } else {
                    tooltips.add(new class_2588("text.rei.cheating_enabled_no_perms"));
                }
            } else if (ClientHelperImpl.getInstance().hasPermissionToUsePackets()) {
                tooltips.add(new class_2588("text.rei.cheating_enabled"));
            } else {
                tooltips.add(new class_2588("text.rei.cheating_limited_enabled"));
            }
            return tooltips.toArray(new class_2561[0]);
        }), Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            helper.method_25304(helper.method_25305() + 1);
            RenderSystem.setShaderTexture((int)0, (class_2960)CHEST_GUI_TEXTURE);
            helper.method_25302(matrices, configButtonArea.x + 3, configButtonArea.y + 3, 0, 0, 14, 14);
        })), 0.0, 0.0, 600.0));
        this.widgets.add(this.configButton);
        Rectangle subsetsButtonBounds = this.getSubsetsButtonBounds();
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            this.widgets.add(InternalWidgets.wrapLateRenderable(Widgets.withTranslate(Widgets.createButton(subsetsButtonBounds, (class_2561)((Boolean)ClientHelperImpl.getInstance().isAprilFools.method_15332() != false ? new class_2588("text.rei.tiny_potato") : new class_2588("text.rei.subsets"))).onClick(button -> this.proceedOpenMenuOrElse(Menu.SUBSETS, () -> this.openMenu(Menu.SUBSETS, Menu.createSubsetsMenuFromRegistry(subsetsButtonBounds), point -> true, point -> true), menu -> this.closeOverlayMenu())), 0.0, 0.0, 600.0)));
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10), class_333.field_18967, label -> {
                if (!class_437.method_25442()) {
                    ENTRY_LIST_WIDGET.setPage(0);
                    ENTRY_LIST_WIDGET.updateEntriesPosition();
                } else {
                    ScreenOverlayImpl.getInstance().choosePageWidget = new DefaultDisplayChoosePageWidget(page -> {
                        ENTRY_LIST_WIDGET.setPage(page);
                        ENTRY_LIST_WIDGET.updateEntriesPosition();
                    }, ENTRY_LIST_WIDGET.getPage(), ENTRY_LIST_WIDGET.getTotalPages());
                }
            }).tooltip(new class_2561[]{new class_2588("text.rei.go_back_first_page"), new class_2585(" "), new class_2588("text.rei.shift_click_to", new Object[]{new class_2588("text.rei.choose_page")}).method_27692(class_124.field_1080)}).focusable(false).onRender((matrices, label) -> {
                label.setClickable(ENTRY_LIST_WIDGET.getTotalPages() > 1);
                label.setMessage((class_5348)new class_2585(String.format("%s/%s", ENTRY_LIST_WIDGET.getPage() + 1, Math.max(ENTRY_LIST_WIDGET.getTotalPages(), 1))));
            }).rainbow((double)new Random().nextFloat() < 1.0E-4 || (Boolean)ClientHelperImpl.getInstance().isAprilFools.method_15332() != false));
        }
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            Rectangle area = this.getCraftableToggleArea();
            class_918 itemRenderer = class_310.method_1551().method_1480();
            class_1799 icon = new class_1799((class_1935)class_2246.field_9980);
            this.widgets.add(Widgets.withTranslate(InternalWidgets.wrapLateRenderable(InternalWidgets.concatWidgets(Widgets.createButton(area, class_333.field_18967).focusable(false).onClick(button -> {
                ConfigManager.getInstance().toggleCraftableOnly();
                ENTRY_LIST_WIDGET.updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
            }).onRender((matrices, button) -> button.setTint(ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776)).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLineSupplier(button -> new class_2588(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all")), Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                class_1162 vector = new class_1162((float)(area.x + 2), (float)(area.y + 2), (float)(helper.method_25305() - 10), 1.0f);
                vector.method_22674(matrices.method_23760().method_23761());
                itemRenderer.field_4730 = vector.method_4957();
                itemRenderer.method_4010(icon, (int)vector.method_4953(), (int)vector.method_4956());
                itemRenderer.field_4730 = 0.0f;
            }))), 0.0, 0.0, 600.0));
        }
        this.widgets.add(this.draggingStack);
    }

    private Collection<MenuEntry> provideConfigButtonMenu() {
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        MenuEntry[] menuEntryArray = new MenuEntry[7];
        menuEntryArray[0] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.cheating"), config::isCheating, config::setCheating);
        menuEntryArray[1] = new SeparatorMenuEntry();
        menuEntryArray[2] = ToggleMenuEntry.ofDeciding((class_2561)new class_2588("text.rei.config.menu.dark_theme"), config::isUsingDarkTheme, dark -> {
            config.setUsingDarkTheme(dark);
            return false;
        });
        menuEntryArray[3] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.config.menu.craftable_filter"), config::isCraftableFilterEnabled, config::setCraftableFilterEnabled);
        MenuEntry[] menuEntryArray2 = new MenuEntry[7];
        menuEntryArray2[0] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.config.menu.display.remove_recipe_book"), config::doesDisableRecipeBook, disableRecipeBook -> {
            config.setDisableRecipeBook(disableRecipeBook);
            class_437 screen = class_310.method_1551().field_1755;
            if (screen != null) {
                screen.method_25423(this.minecraft, screen.field_22789, screen.field_22790);
            }
        });
        menuEntryArray2[1] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.config.menu.display.left_side_mob_effects"), config::isLeftSideMobEffects, disableRecipeBook -> {
            config.setLeftSideMobEffects(disableRecipeBook);
            class_437 screen = class_310.method_1551().field_1755;
            if (screen != null) {
                screen.method_25423(this.minecraft, screen.field_22789, screen.field_22790);
            }
        });
        menuEntryArray2[2] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.config.menu.display.left_side_panel"), config::isLeftHandSidePanel, bool -> config.setDisplayPanelLocation(bool ? DisplayPanelLocation.LEFT : DisplayPanelLocation.RIGHT));
        menuEntryArray2[3] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.config.menu.display.scrolling_side_panel"), config::isEntryListWidgetScrolled, config::setEntryListWidgetScrolled);
        menuEntryArray2[4] = new SeparatorMenuEntry();
        menuEntryArray2[5] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.config.menu.display.side_search_field"), () -> config.getSearchFieldLocation() != SearchFieldLocation.CENTER, bool -> config.setSearchFieldLocation(bool ? SearchFieldLocation.BOTTOM_SIDE : SearchFieldLocation.CENTER));
        menuEntryArray2[6] = ToggleMenuEntry.of((class_2561)new class_2588("text.rei.config.menu.display.syntax_highlighting"), () -> config.getSyntaxHighlightingMode() == SyntaxHighlightingMode.COLORFUL || config.getSyntaxHighlightingMode() == SyntaxHighlightingMode.COLORFUL_UNDERSCORED, bool -> config.setSyntaxHighlightingMode(bool ? SyntaxHighlightingMode.COLORFUL : SyntaxHighlightingMode.PLAIN_UNDERSCORED));
        menuEntryArray[4] = new SubMenuEntry((class_2561)new class_2588("text.rei.config.menu.display"), Arrays.asList(menuEntryArray2));
        menuEntryArray[5] = new SeparatorMenuEntry();
        menuEntryArray[6] = ToggleMenuEntry.ofDeciding((class_2561)new class_2588("text.rei.config.menu.config"), () -> false, $ -> {
            ConfigManager.getInstance().openConfigScreen(REIRuntime.getInstance().getPreviousScreen());
            return false;
        });
        return Arrays.asList(menuEntryArray);
    }

    private Rectangle getSubsetsButtonBounds() {
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            ScreenRegistry registry = ScreenRegistry.getInstance();
            Rectangle screenBounds = registry.getScreenBounds(this.minecraft.field_1755);
            return new Rectangle(screenBounds.x, 3, screenBounds.width, 18);
        }
        return null;
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546()) {
            return Weather.THUNDER;
        }
        if (world.method_28104().method_156()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(class_1934 gameMode) {
        return class_1074.method_4662((String)("text.rei.short_gamemode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private String getGameModeText(class_1934 gameMode) {
        return class_1074.method_4662((String)("selectWorld.gameMode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private class_1934 getCurrentGameMode() {
        class_640 info = class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId());
        return info == null ? class_1934.field_9215 : info.method_2958();
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1;
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            widthRemoved += 22;
        }
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            widthRemoved += 22;
        }
        SearchFieldLocation searchFieldLocation = REIRuntime.getInstance().getContextualSearchFieldLocation();
        switch (searchFieldLocation) {
            case TOP_SIDE: {
                return this.getTopSideSearchFieldArea(widthRemoved);
            }
            case BOTTOM_SIDE: {
                return this.getBottomSideSearchFieldArea(widthRemoved);
            }
        }
        return this.getCenterSearchFieldArea(widthRemoved);
    }

    private Rectangle getTopSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getBottomSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, this.window.method_4502() - 22, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getCenterSearchFieldArea(int widthRemoved) {
        Rectangle screenBounds = ScreenRegistry.getInstance().getScreenBounds(this.minecraft.field_1755);
        return this.getBottomCenterSearchFieldArea(screenBounds, widthRemoved);
    }

    private Rectangle getBottomCenterSearchFieldArea(Rectangle containerBounds, int widthRemoved) {
        return new Rectangle(containerBounds.x, this.window.method_4502() - 22, containerBounds.width - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle area = this.getSearchFieldArea();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }

    private Rectangle getConfigButtonArea() {
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            Rectangle area = this.getSearchFieldArea();
            area.setLocation(area.x + area.width + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 26 : 4), area.y - 1);
            area.setSize(20, 20);
            return area;
        }
        return new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10, 10, 20, 20);
    }

    private String getCheatModeText() {
        return class_1074.method_4662((String)String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle getScreenBounds() {
        return this.screenBounds;
    }

    public void method_25394(class_4587 matrices, final int mouseX, final int mouseY, float delta) {
        if (this.shouldReload || !ScreenOverlayImpl.calculateOverlayBounds().equals((Object)this.bounds)) {
            this.init();
            ENTRY_LIST_WIDGET.updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        } else {
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(this.minecraft.field_1755)) {
                if (decider == null || !decider.shouldRecalculateArea(ConfigObject.getInstance().getDisplayPanelLocation(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (this.shouldReloadSearch || ConfigManager.getInstance().isCraftableOnlyEnabled() && CraftableFilter.INSTANCE.wasDirty()) {
            this.shouldReloadSearch = false;
            ENTRY_LIST_WIDGET.updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isHighlighting) {
            OverlayDecider decider;
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            decider = class_310.method_1551().field_1755;
            if (decider instanceof class_465) {
                class_465 containerScreen = (class_465)decider;
                int x = containerScreen.field_2776;
                int y = containerScreen.field_2800;
                for (class_1735 slot : containerScreen.method_17577().field_7761) {
                    if (!slot.method_7681() || !ENTRY_LIST_WIDGET.matches(EntryStacks.of(slot.method_7677()))) {
                        matrices.method_22903();
                        matrices.method_22904(0.0, 0.0, 500.0);
                        this.method_25296(matrices, x + slot.field_7873, y + slot.field_7872, x + slot.field_7873 + 16, y + slot.field_7872 + 16, -601874400, -601874400);
                        matrices.method_22909();
                        continue;
                    }
                    matrices.method_22903();
                    matrices.method_22904(0.0, 0.0, 200.0);
                    this.method_25296(matrices, x + slot.field_7873, y + slot.field_7872, x + slot.field_7873 + 16, y + slot.field_7872 + 16, 878706491, 878706491);
                    this.method_25296(matrices, x + slot.field_7873 - 1, y + slot.field_7872 - 1, x + slot.field_7873, y + slot.field_7872 + 16 + 1, -10485957, -10485957);
                    this.method_25296(matrices, x + slot.field_7873 + 16, y + slot.field_7872 - 1, x + slot.field_7873 + 16 + 1, y + slot.field_7872 + 16 + 1, -10485957, -10485957);
                    this.method_25296(matrices, x + slot.field_7873 - 1, y + slot.field_7872 - 1, x + slot.field_7873 + 16, y + slot.field_7872, -10485957, -10485957);
                    this.method_25296(matrices, x + slot.field_7873 - 1, y + slot.field_7872 + 16, x + slot.field_7873 + 16, y + slot.field_7872 + 16 + 1, -10485957, -10485957);
                    matrices.method_22909();
                }
            }
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
        if (!this.hasSpace()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderWidgets(matrices, mouseX, mouseY, delta);
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            final class_437 screen = class_310.method_1551().field_1755;
            ClickArea.ClickAreaContext<class_437> context = new ClickArea.ClickAreaContext<class_437>(){

                @Override
                public class_437 getScreen() {
                    return screen;
                }

                @Override
                public Point getMousePosition() {
                    return new Point(mouseX, mouseY);
                }
            };
            List<class_2561> clickAreaTooltips = ScreenRegistry.getInstance().getClickAreaTooltips(screen.getClass(), context);
            if (clickAreaTooltips != null && !clickAreaTooltips.isEmpty()) {
                Tooltip.create(clickAreaTooltips).queue();
            }
        }
    }

    private static Rectangle calculateOverlayBounds() {
        Rectangle bounds = ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation(), class_310.method_1551().field_1755);
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundariesPercentage()));
        if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.RIGHT) {
            bounds.x += widthReduction;
        }
        bounds.width -= widthReduction;
        int maxWidth = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getHorizontalEntriesBoundariesColumns() + (double)EntryListWidget.entrySize() * 0.75);
        if (bounds.width > maxWidth) {
            if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.RIGHT) {
                bounds.x += bounds.width - maxWidth;
            }
            bounds.width = maxWidth;
        }
        return bounds;
    }

    public void lateRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (REIRuntime.getInstance().isOverlayVisible() && this.hasSpace()) {
            REIRuntimeImpl.getSearchField().laterRender(matrices, mouseX, mouseY, delta);
            for (Widget widget : this.widgets) {
                if (!(widget instanceof LateRenderable) || this.overlayMenu != null && this.overlayMenu.wrappedMenu == widget) continue;
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
            if (this.overlayMenu != null) {
                if (!this.overlayMenu.inBounds.test(PointHelper.ofMouse())) {
                    this.closeOverlayMenu();
                } else {
                    if (this.overlayMenu.wrappedMenu.containsMouse(mouseX, mouseY)) {
                        TOOLTIPS.clear();
                    }
                    this.overlayMenu.wrappedMenu.method_25394(matrices, mouseX, mouseY, delta);
                }
            }
            if (this.choosePageWidget != null) {
                this.method_25304(500);
                this.method_25296(matrices, 0, 0, this.window.method_4486(), this.window.method_4502(), -1072689136, -804253680);
                this.method_25304(0);
                this.choosePageWidget.method_25394(matrices, mouseX, mouseY, delta);
            }
        }
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (this.choosePageWidget == null) {
            for (Tooltip tooltip : TOOLTIPS) {
                if (tooltip == null) continue;
                this.renderTooltip(matrices, tooltip);
            }
        }
        TOOLTIPS.clear();
        if (REIRuntime.getInstance().isOverlayVisible()) {
            for (Runnable runnable : AFTER_RENDER) {
                runnable.run();
            }
            AFTER_RENDER.clear();
        }
    }

    public void renderTooltip(class_4587 matrices, Tooltip tooltip) {
        ScreenOverlayImpl.renderTooltipInner(this.minecraft.field_1755, matrices, tooltip, tooltip.getX(), tooltip.getY());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderTooltipInner(class_437 screen, class_4587 matrices, Tooltip tooltip, int mouseX, int mouseY) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ScreenOverlayImplImpl.renderTooltipInner(screen, (class_4587)var1_1, (Tooltip)var2_2, (int)var3_3, (int)var4_4);
    }

    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null) {
            TOOLTIPS.add(tooltip);
        }
    }

    public void renderWidgets(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.leftButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
            this.rightButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
        }
        for (Widget widget : this.widgets) {
            if (widget instanceof LateRenderable) continue;
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (this.overlayMenu != null && this.overlayMenu.wrappedMenu.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.isInside(PointHelper.ofMouse())) {
            if (ENTRY_LIST_WIDGET.method_25401(mouseX, mouseY, amount)) {
                return true;
            }
            if (!class_437.method_25441() && !ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                if (amount > 0.0 && this.leftButton.isEnabled()) {
                    this.leftButton.onClick();
                } else if (amount < 0.0 && this.rightButton.isEnabled()) {
                    this.rightButton.onClick();
                } else {
                    return false;
                }
                return true;
            }
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ENTRY_LIST_WIDGET || favoritesListWidget != null && widget == favoritesListWidget || this.overlayMenu != null && widget == this.overlayMenu.wrappedMenu || !widget.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible()) {
            if (keyCode == 256 && this.choosePageWidget != null) {
                this.choosePageWidget = null;
                return true;
            }
            if (this.choosePageWidget != null) {
                return this.choosePageWidget.method_25404(keyCode, scanCode, modifiers);
            }
            if (REIRuntimeImpl.getSearchField().method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            for (class_364 class_3642 : this.widgets) {
                if (class_3642 == REIRuntimeImpl.getSearchField() || !class_3642.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return true;
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(class_310.method_1551().field_1755, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                ConfigManager.getInstance().saveConfig();
                FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
                if (favoritesListWidget != null) {
                    favoritesListWidget.updateSearch();
                }
                return true;
            }
        }
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.method_25395((class_364)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = System.currentTimeMillis();
            REIRuntimeImpl.getSearchField().keybindFocusKey = keyCode;
            return true;
        }
        return false;
    }

    public boolean method_25400(char character, int modifiers) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.method_25400(character, modifiers);
        }
        if (REIRuntimeImpl.getSearchField().method_25400(character, modifiers)) {
            return true;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == REIRuntimeImpl.getSearchField() || !class_3642.method_25400(character, modifiers)) continue;
            return true;
        }
        return false;
    }

    public List<Widget> method_25396() {
        return this.widgets;
    }

    public boolean method_25402(final double mouseX, final double mouseY, int button) {
        boolean visible = REIRuntime.getInstance().isOverlayVisible();
        if (this.choosePageWidget != null) {
            if (this.choosePageWidget.containsMouse(mouseX, mouseY)) {
                return this.choosePageWidget.method_25402(mouseX, mouseY, button);
            }
            this.choosePageWidget = null;
            this.init();
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (visible && this.configButton.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.configButton);
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesMouse(button)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return REIRuntime.getInstance().isOverlayVisible();
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(class_310.method_1551().field_1755, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (visible && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(button)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                ConfigManager.getInstance().saveConfig();
                FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
                if (favoritesListWidget != null) {
                    favoritesListWidget.updateSearch();
                }
                return true;
            }
        }
        if (visible && this.overlayMenu != null && this.overlayMenu.wrappedMenu.method_25402(mouseX, mouseY, button)) {
            if (this.overlayMenu != null) {
                this.method_25395((class_364)this.overlayMenu.wrappedMenu);
            } else {
                this.method_25395(null);
            }
            if (button == 0) {
                this.method_25398(true);
            }
            REIRuntimeImpl.getSearchField().setFocused(false);
            return true;
        }
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            final class_437 screen = class_310.method_1551().field_1755;
            ClickArea.ClickAreaContext<class_437> clickAreaContext = new ClickArea.ClickAreaContext<class_437>(){

                @Override
                public class_437 getScreen() {
                    return screen;
                }

                @Override
                public Point getMousePosition() {
                    return new Point(mouseX, mouseY);
                }
            };
            if (ScreenRegistry.getInstance().executeClickArea(screen.getClass(), clickAreaContext)) {
                return true;
            }
        }
        if (!visible) {
            return false;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == this.configButton || this.overlayMenu != null && class_3642 == this.overlayMenu.wrappedMenu || !class_3642.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(class_3642);
            if (button == 0) {
                this.method_25398(true);
            }
            if (!(class_3642 instanceof OverlaySearchField)) {
                REIRuntimeImpl.getSearchField().setFocused(false);
            }
            return true;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesMouse(button)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.method_25395((class_364)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = -1L;
            REIRuntimeImpl.getSearchField().keybindFocusKey = -1;
            return true;
        }
        return false;
    }

    public boolean method_25403(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.method_25403(double_1, double_2, int_1, double_3, double_4);
        }
        return this.method_25399() != null && this.method_25397() && int_1 == 0 && this.method_25399().method_25403(double_1, double_2, int_1, double_3, double_4);
    }

    @Override
    public class_364 method_25399() {
        if (this.choosePageWidget != null) {
            return this.choosePageWidget;
        }
        return super.method_25399();
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    @Override
    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(class_310.method_1551().field_1755)) {
            class_1269 in = decider.isInZone(mouseX, mouseY);
            if (in == class_1269.field_5811) continue;
            return in == class_1269.field_5812;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }

    @Override
    public OverlayListWidget getEntryList() {
        return ENTRY_LIST_WIDGET;
    }

    @Override
    public Optional<OverlayListWidget> getFavoritesList() {
        return Optional.ofNullable(ScreenOverlayImpl.getFavoritesListWidget());
    }

    private static class OverlayMenu {
        private UUID uuid;
        private Menu menu;
        private Widget wrappedMenu;
        private Predicate<Point> inBounds;

        public OverlayMenu(UUID uuid, Menu menu, Widget wrappedMenu, Predicate<Point> or, Predicate<Point> and) {
            this.uuid = uuid;
            this.menu = menu;
            this.wrappedMenu = wrappedMenu;
            this.inBounds = or.or(menu::containsMouse).and(and);
        }
    }
}

