/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.util;

import com.google.common.collect.ImmutableList;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3611;

public final class EntryIngredients {
    private EntryIngredients() {
    }

    public static EntryIngredient of(class_1935 stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(class_1935 stack, int amount) {
        return EntryIngredient.of(EntryStacks.of(stack, amount));
    }

    public static EntryIngredient of(class_1799 stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(class_3611 fluid) {
        return EntryIngredient.of(EntryStacks.of(fluid));
    }

    public static EntryIngredient of(class_3611 fluid, long amount) {
        return EntryIngredient.of(EntryStacks.of(fluid, amount));
    }

    public static EntryIngredient of(FluidStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static <T> EntryIngredient of(EntryType<T> type, Collection<T> values) {
        return EntryIngredients.of(type.getDefinition(), values);
    }

    public static <T> EntryIngredient of(EntryDefinition<T> definition, Collection<T> values) {
        if (values.size() == 0) {
            return EntryIngredient.empty();
        }
        if (values.size() == 1) {
            return EntryIngredient.of(EntryStack.of(definition, values.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(values.size());
        for (T value : values) {
            result.add((EntryStack<?>)EntryStack.of(definition, value));
        }
        return result.build();
    }

    public static EntryIngredient ofItems(Collection<class_1935> stacks) {
        return EntryIngredients.ofItems(stacks, 1);
    }

    public static EntryIngredient ofItems(Collection<class_1935> stacks, int amount) {
        if (stacks.size() == 0) {
            return EntryIngredient.empty();
        }
        if (stacks.size() == 1) {
            return EntryIngredient.of(EntryStacks.of(stacks.iterator().next(), amount));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(stacks.size());
        for (class_1935 stack : stacks) {
            result.add((EntryStack<?>)EntryStacks.of(stack, amount));
        }
        return result.build();
    }

    public static EntryIngredient ofItemStacks(Collection<class_1799> stacks) {
        return EntryIngredients.of(VanillaEntryTypes.ITEM, stacks);
    }

    public static EntryIngredient ofIngredient(class_1856 ingredient) {
        if (ingredient.method_8103()) {
            return EntryIngredient.empty();
        }
        class_1799[] matchingStacks = ingredient.method_8105();
        if (matchingStacks.length == 0) {
            return EntryIngredient.empty();
        }
        if (matchingStacks.length == 1) {
            return EntryIngredient.of(EntryStacks.of(matchingStacks[0]));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(matchingStacks.length);
        for (class_1799 matchingStack : matchingStacks) {
            if (matchingStack.method_7960()) continue;
            result.add((EntryStack<?>)EntryStacks.of(matchingStack));
        }
        return result.build();
    }

    public static List<EntryIngredient> ofIngredients(List<class_1856> ingredients) {
        if (ingredients.size() == 0) {
            return Collections.emptyList();
        }
        if (ingredients.size() == 1) {
            class_1856 ingredient = ingredients.get(0);
            if (ingredient.method_8103()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(EntryIngredients.ofIngredient(ingredient));
        }
        boolean emptyFlag = true;
        ArrayList<EntryIngredient> result = new ArrayList<EntryIngredient>(ingredients.size());
        for (int i = ingredients.size() - 1; i >= 0; --i) {
            class_1856 ingredient = ingredients.get(i);
            if (emptyFlag && ingredient.method_8103()) continue;
            result.add(0, EntryIngredients.ofIngredient(ingredient));
            emptyFlag = false;
        }
        return ImmutableList.copyOf(result);
    }

    public static <T> boolean testFuzzy(EntryIngredient ingredient, EntryStack<T> stack) {
        for (EntryStack ingredientStack : ingredient) {
            if (!EntryStacks.equalsFuzzy(ingredientStack, stack)) continue;
            return true;
        }
        return false;
    }

    public static class_2499 save(List<EntryIngredient> ingredients) {
        class_2499 listTag = new class_2499();
        for (EntryIngredient ingredient : ingredients) {
            listTag.add((Object)ingredient.save());
        }
        return listTag;
    }

    public static List<EntryIngredient> read(class_2499 listTag) {
        if (listTag.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (class_2520 tag : listTag) {
            ingredients.add((Object)EntryIngredient.read((class_2499)tag));
        }
        return ingredients.build();
    }
}

