/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer.info.simple;

import com.google.common.base.MoreObjects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.RecipeFinderPopulator;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.clean.InputCleanHandler;
import me.shedaniel.rei.api.common.transfer.info.simple.DumpHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;

public interface SimplePlayerInventoryMenuInfo<T extends class_1703, D extends Display>
extends MenuInfo<T, D> {
    @Override
    default public RecipeFinderPopulator<T, D> getRecipeFinderPopulator() {
        return (context, finder) -> {
            for (SlotAccessor inventoryStack : this.getInventorySlots(context)) {
                finder.addNormalItem(inventoryStack.getItemStack());
            }
            this.populateRecipeFinder(context.getMenu(), finder);
        };
    }

    @Override
    default public InputCleanHandler<T, D> getInputCleanHandler() {
        return context -> {
            Object container = context.getMenu();
            for (SlotAccessor gridStack : this.getInputSlots(context)) {
                InputCleanHandler.returnSlotsToPlayerInventory(context, this.getDumpHandler(), gridStack);
            }
            this.clearInputSlots(container);
        };
    }

    default public DumpHandler<T, D> getDumpHandler() {
        return (context, stackToDump) -> {
            Iterable<SlotAccessor> inventoryStacks = this.getInventorySlots(context);
            SlotAccessor nextSlot = (SlotAccessor)MoreObjects.firstNonNull((Object)DumpHandler.getOccupiedSlotWithRoomForStack(stackToDump, inventoryStacks), (Object)DumpHandler.getEmptySlot(inventoryStacks));
            if (nextSlot == null) {
                return false;
            }
            class_1799 stack = stackToDump.method_7972();
            stack.method_7939(nextSlot.getItemStack().method_7947() + stack.method_7947());
            nextSlot.setItemStack(stack);
            return true;
        };
    }

    @Override
    default public Iterable<SlotAccessor> getInventorySlots(MenuInfoContext<T, ?, D> context) {
        class_1661 inventory = context.getPlayerEntity().method_31548();
        return IntStream.range(0, inventory.field_7547.size()).mapToObj(index -> SlotAccessor.fromContainer((class_1263)inventory, index)).collect(Collectors.toList());
    }

    default public void populateRecipeFinder(T menu, RecipeFinder finder) {
    }

    default public void clearInputSlots(T menu) {
    }
}

