/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_437;

public interface DraggableStackVisitor<T extends class_437>
extends Comparable<DraggableStackVisitor<T>> {
    public static <T extends class_437> DraggableStackVisitor<T> from(final Supplier<Iterable<DraggableStackVisitor<T>>> visitors) {
        return new DraggableStackVisitor<T>(){

            @Override
            public <R extends class_437> boolean isHandingScreen(R screen) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    if (!visitor.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    DraggedAcceptorResult result;
                    if (!visitor.isHandingScreen(context.getScreen()) || (result = Objects.requireNonNull(visitor.acceptDraggedStack(context, stack))) == DraggedAcceptorResult.PASS) continue;
                    return result;
                }
                return DraggedAcceptorResult.PASS;
            }

            @Override
            public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
                return StreamSupport.stream(((Iterable)visitors.get()).spliterator(), false).filter(visitor -> visitor.isHandingScreen(context.getScreen())).flatMap(visitor -> visitor.getDraggableAcceptingBounds(context, stack));
            }
        };
    }

    default public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
        return DraggedAcceptorResult.PASS;
    }

    default public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
        return Stream.empty();
    }

    public <R extends class_437> boolean isHandingScreen(R var1);

    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableStackVisitor<T> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @FunctionalInterface
    public static interface BoundsProvider {
        public static class_265 fromRectangle(Rectangle bounds) {
            return class_259.method_1081((double)bounds.x, (double)bounds.y, (double)0.0, (double)bounds.getMaxX(), (double)bounds.getMaxY(), (double)0.1);
        }

        public static BoundsProvider ofRectangle(Rectangle bounds) {
            return BoundsProvider.ofShape(BoundsProvider.fromRectangle(bounds));
        }

        public static BoundsProvider ofRectangles(Iterable<Rectangle> bounds) {
            class_265 shape = StreamSupport.stream(bounds.spliterator(), false).map(BoundsProvider::fromRectangle).reduce(class_259.method_1073(), class_259::method_1084);
            return BoundsProvider.ofShape(shape);
        }

        public static BoundsProvider ofShape(class_265 shape) {
            return () -> shape;
        }

        public static BoundsProvider ofShapes(Iterable<class_265> shapes) {
            class_265 shape = StreamSupport.stream(shapes.spliterator(), false).reduce(class_259.method_1073(), class_259::method_1084);
            return BoundsProvider.ofShape(shape);
        }

        public static BoundsProvider empty() {
            return class_259::method_1073;
        }

        public static BoundsProvider concat(Iterable<BoundsProvider> providers) {
            return () -> StreamSupport.stream(providers.spliterator(), false).map(BoundsProvider::bounds).reduce(class_259.method_1073(), class_259::method_1084);
        }

        public class_265 bounds();
    }

    @FunctionalInterface
    public static interface Acceptor {
        public void accept(DraggableStack var1);
    }
}

