/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.animator;

import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.animator.ValueAnimator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class MappingValueAnimator<T, R>
implements ValueAnimator<R> {
    private final ValueAnimator<T> parent;
    private final Function<T, R> converter;
    private final Function<R, T> backwardsConverter;

    MappingValueAnimator(ValueAnimator<T> parent, Function<T, R> converter, Function<R, T> backwardsConverter) {
        this.parent = parent;
        this.converter = converter;
        this.backwardsConverter = backwardsConverter;
    }

    @Override
    public ValueAnimator<R> setTo(R value, long duration) {
        this.parent.setTo(this.backwardsConverter.apply(value), duration);
        return this;
    }

    @Override
    public R target() {
        return this.converter.apply(this.parent.target());
    }

    @Override
    public R value() {
        return this.converter.apply(this.parent.value());
    }

    @Override
    public void update(double delta) {
        this.parent.update(delta);
    }
}

