/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.TickerUtil;
import com.tom.storagemod.block.ITrim;
import com.tom.storagemod.tile.TileEntityInventoryCableConnectorBase;
import com.tom.storagemod.tile.TileEntityInventoryProxy;
import com.tom.storagemod.util.IProxy;
import com.tom.storagemod.util.InfoHandler;
import com.tom.storagemod.util.InventoryWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3902;
import net.minecraft.class_3954;

public class TileEntityInventoryConnector
extends class_2586
implements TickerUtil.TickableServer,
class_1263 {
    private List<InventoryWrapper> handlers = new ArrayList<InventoryWrapper>();
    private List<LinkedInv> linkedInvs = new ArrayList<LinkedInv>();
    private int[] invSizes = new int[0];
    private int invSize;
    private boolean calling;

    public TileEntityInventoryConnector(class_2338 pos, class_2680 state) {
        super(StorageMod.connectorTile, pos, state);
    }

    @Override
    public void updateServer() {
        long time = this.field_11863.method_8510();
        if (time % 20L == 0L) {
            Stack<class_2338> toCheck = new Stack<class_2338>();
            HashSet<class_2338> checkedBlocks = new HashSet<class_2338>();
            toCheck.add(this.field_11867);
            checkedBlocks.add(this.field_11867);
            this.handlers.clear();
            HashSet<LinkedInv> toRM = new HashSet<LinkedInv>();
            for (LinkedInv inv : this.linkedInvs) {
                TileEntityInventoryConnector ih;
                if (inv.time + 40L < time) {
                    toRM.add(inv);
                    continue;
                }
                class_2350[] w = inv.handler.get();
                if (w == null) continue;
                class_1263 ihr = IProxy.resolve(w.getInventory());
                if (ihr instanceof TileEntityInventoryConnector && this.checkHandlers(ih = (TileEntityInventoryConnector)ihr, 0)) {
                    if (this.handlers.contains(InfoHandler.INSTANCE)) continue;
                    this.handlers.add(InfoHandler.INSTANCE);
                    continue;
                }
                this.handlers.add((InventoryWrapper)w);
            }
            this.linkedInvs.removeAll(toRM);
            Collections.sort(this.linkedInvs);
            int range = StorageMod.CONFIG.invRange * StorageMod.CONFIG.invRange;
            while (!toCheck.isEmpty()) {
                class_2338 cp = (class_2338)toCheck.pop();
                for (class_2350 d : class_2350.values()) {
                    class_2338 p = cp.method_10093(d);
                    if (checkedBlocks.contains(p) || !(p.method_10262((class_2382)this.field_11867) < (double)range)) continue;
                    checkedBlocks.add(p);
                    class_2680 state = this.field_11863.method_8320(p);
                    if (state.method_26204() instanceof ITrim) {
                        toCheck.add(p);
                        continue;
                    }
                    class_2586 te = this.field_11863.method_8321(p);
                    if (te instanceof TileEntityInventoryConnector || te instanceof TileEntityInventoryProxy || te instanceof TileEntityInventoryCableConnectorBase || te == null || StorageMod.CONFIG.onlyTrims) continue;
                    class_1263 ihr = null;
                    class_1263 inv = TileEntityInventoryConnector.getInventoryAt(this.field_11863, p);
                    if (te instanceof class_2595) {
                        class_2248 block = state.method_26204();
                        if (block instanceof class_2281) {
                            ihr = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)state, (class_1937)this.field_11863, (class_2338)p, (boolean)true);
                            class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
                            if (type != class_2745.field_12569) {
                                class_2745 otype;
                                class_2338 opos = p.method_10093(class_2281.method_9758((class_2680)state));
                                class_2680 ostate = this.method_10997().method_8320(opos);
                                if (state.method_26204() == ostate.method_26204() && (otype = (class_2745)ostate.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569 && type != otype && state.method_11654((class_2769)class_2281.field_10768) == ostate.method_11654((class_2769)class_2281.field_10768)) {
                                    toCheck.add(opos);
                                    checkedBlocks.add(opos);
                                }
                            }
                        }
                    } else if (inv != null) {
                        TileEntityInventoryConnector ih;
                        ihr = IProxy.resolve(inv);
                        if (ihr instanceof TileEntityInventoryConnector && this.checkHandlers(ih = (TileEntityInventoryConnector)ihr, 0)) {
                            if (this.handlers.contains(InfoHandler.INSTANCE)) continue;
                            this.handlers.add(InfoHandler.INSTANCE);
                            continue;
                        }
                        if (!(te instanceof TileEntityInventoryCableConnectorBase)) {
                            toCheck.add(p);
                        }
                    }
                    if (ihr != null) {
                        this.handlers.add(new InventoryWrapper(ihr, d.method_10153()));
                    }
                    if (!Config.getMultiblockInvs().contains(state.method_26204())) continue;
                    this.skipBlocks(p, checkedBlocks, toCheck, state.method_26204());
                }
            }
            if (this.invSizes.length != this.handlers.size()) {
                this.invSizes = new int[this.handlers.size()];
            }
            this.invSize = 0;
            for (int i = 0; i < this.invSizes.length; ++i) {
                int s;
                InventoryWrapper ih = this.handlers.get(i);
                if (ih == null) {
                    this.invSizes[i] = 0;
                    continue;
                }
                this.invSizes[i] = s = ih.size();
                this.invSize += s;
            }
        }
    }

    private void skipBlocks(class_2338 pos, Set<class_2338> checkedBlocks, Stack<class_2338> edges, class_2248 block) {
        Stack<class_2338> toCheck = new Stack<class_2338>();
        toCheck.add(pos);
        edges.add(pos);
        while (!toCheck.isEmpty()) {
            class_2338 cp = (class_2338)toCheck.pop();
            for (class_2350 d : class_2350.values()) {
                class_2680 state;
                class_2338 p = cp.method_10093(d);
                if (checkedBlocks.contains(p) || !(p.method_10262((class_2382)pos) < (double)StorageMod.CONFIG.invRange) || (state = this.field_11863.method_8320(p)).method_26204() != block) continue;
                checkedBlocks.add(p);
                edges.add(p);
                toCheck.add(p);
            }
        }
    }

    private boolean checkHandlers(TileEntityInventoryConnector ih, int depth) {
        if (depth > 3) {
            return true;
        }
        for (InventoryWrapper lo : ih.handlers) {
            class_1263 ihr = IProxy.resolve(lo.getInventory());
            if (ihr == this) {
                return true;
            }
            if (!(ihr instanceof TileEntityInventoryConnector) || !this.checkHandlers((TileEntityInventoryConnector)ihr, depth + 1)) continue;
            return true;
        }
        return false;
    }

    public <R> R call(BiFunction<InventoryWrapper, Integer, R> func, int slot, R def) {
        if (this.calling) {
            return def;
        }
        this.calling = true;
        for (int i = 0; i < this.invSizes.length; ++i) {
            if (slot >= this.invSizes[i]) {
                slot -= this.invSizes[i];
                continue;
            }
            R r = func.apply(this.handlers.get(i), slot);
            this.calling = false;
            return r;
        }
        this.calling = false;
        return def;
    }

    public void method_5448() {
    }

    public int method_5439() {
        return this.invSize;
    }

    public boolean method_5442() {
        return false;
    }

    public class_1799 method_5438(int paramInt) {
        return this.call(InventoryWrapper::getStack, paramInt, class_1799.field_8037);
    }

    public class_1799 method_5434(int paramInt1, int paramInt2) {
        return this.call((i, s) -> i.removeStack((int)s, paramInt2), paramInt1, class_1799.field_8037);
    }

    public class_1799 method_5441(int paramInt) {
        return this.call(InventoryWrapper::removeStack, paramInt, class_1799.field_8037);
    }

    public void method_5447(int paramInt, class_1799 paramItemStack) {
        this.call((i, s) -> {
            i.setStack((int)s, paramItemStack);
            return class_3902.field_17274;
        }, paramInt, class_3902.field_17274);
    }

    public boolean method_5443(class_1657 paramPlayerEntity) {
        return false;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.call((i, s) -> i.isValid((int)s, stack, false), slot, false);
    }

    public void addLinked(LinkedInv inv) {
        this.linkedInvs.add(inv);
    }

    public void unLink(LinkedInv linv) {
        this.linkedInvs.remove(linv);
    }

    public InventoryWrapper getInventory() {
        return new InventoryWrapper(this, class_2350.field_11033);
    }

    public int getFreeSlotCount() {
        int empty = 0;
        for (int i = 0; i < this.invSize; ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            ++empty;
        }
        return empty;
    }

    public static class_1263 getInventoryAt(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = ((class_3954)block).method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = world.method_8321(blockPos)) instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
            inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        return inventory;
    }

    public static class LinkedInv
    implements Comparable<LinkedInv> {
        public Supplier<InventoryWrapper> handler;
        public long time;
        public int priority;

        @Override
        public int compareTo(LinkedInv o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

