/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.NetworkHandler;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.gui.ControllMode;
import com.tom.storagemod.gui.GuiCraftingTerminal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.lwjgl.glfw.GLFW;

public abstract class GuiStorageTerminalBase<T extends ContainerStorageTerminal>
extends class_465<T>
implements NetworkHandler.IDataReceiver {
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<StoredItemStack, List<String>>(){

        public List<String> load(StoredItemStack key) throws Exception {
            return key.getStack().method_7950((class_1657)class_310.method_1551().field_1724, GuiStorageTerminalBase.getTooltipFlag()).stream().map(class_2561::getString).collect(Collectors.toList());
        }
    });
    protected class_310 mc = class_310.method_1551();
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected class_342 searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    protected int searchType;
    protected String searchLast = "";
    protected boolean loadedSearch = false;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected static final class_2960 creativeInventoryTabs = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    protected GuiButton buttonSortingType;
    protected GuiButton buttonDirection;
    protected GuiButton buttonSearchType;
    protected GuiButton buttonCtrlMode;

    public GuiStorageTerminalBase(T screenContainer, class_1661 inv, class_2561 titleIn) {
        super(screenContainer, inv, titleIn);
        ((ContainerStorageTerminal)screenContainer).onPacket = this::onPacket;
    }

    protected void onPacket() {
        int s = ((ContainerStorageTerminal)this.field_2797).terminalData;
        this.controllMode = (s & 3) % ControllMode.VALUES.length;
        boolean rev = (s & 4) > 0;
        int type = (s & 0x18) >> 3;
        this.comparator = StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length].create(rev);
        this.searchType = (s & 0xE0) >> 5;
        this.searchField.method_1856((this.searchType & 1) == 0);
        if (!this.searchField.method_25370() && (this.searchType & 1) > 0) {
            this.searchField.method_1876(true);
        }
        this.buttonSortingType.state = type;
        this.buttonDirection.state = rev ? 1 : 0;
        this.buttonSearchType.state = this.searchType;
        this.buttonCtrlMode.state = this.controllMode;
        if (!this.loadedSearch && ((ContainerStorageTerminal)this.field_2797).search != null) {
            this.loadedSearch = true;
            if ((this.searchType & 2) > 0) {
                this.searchField.method_1852(((ContainerStorageTerminal)this.field_2797).search);
            }
        }
    }

    protected void sendUpdate() {
        class_2487 c = new class_2487();
        c.method_10569("d", this.updateData());
        class_2487 msg = new class_2487();
        msg.method_10566("c", (class_2520)c);
        ((ContainerStorageTerminal)this.field_2797).sendMessage(msg);
    }

    protected int updateData() {
        int d = 0;
        d |= this.controllMode & 3;
        d |= (this.comparator.isReversed() ? 1 : 0) << 2;
        d |= this.comparator.type() << 3;
        return d |= (this.searchType & 7) << 5;
    }

    protected void method_25426() {
        this.method_37067();
        this.field_25270 = this.field_2779 - 92;
        super.method_25426();
        Objects.requireNonNull(this.field_22793);
        this.searchField = new class_342(this.field_22793, this.field_2776 + 82, this.field_2800 + 6, 89, 9, (class_2561)new class_2585(""));
        this.searchField.method_1852(this.searchLast);
        this.searchField.method_1880(100);
        this.searchField.method_1858(false);
        this.searchField.method_1862(true);
        this.searchField.method_1868(0xFFFFFF);
        this.method_37063((class_364)this.searchField);
        this.buttonSortingType = (GuiButton)this.method_37063((class_364)new GuiButton(this.field_2776 - 18, this.field_2800 + 5, 0, b -> {
            this.comparator = StoredItemStack.SortingTypes.VALUES[(this.comparator.type() + 1) % StoredItemStack.SortingTypes.VALUES.length].create(this.comparator.isReversed());
            this.buttonSortingType.state = this.comparator.type();
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (GuiButton)this.method_37063((class_364)new GuiButton(this.field_2776 - 18, this.field_2800 + 5 + 18, 1, b -> {
            this.comparator.setReversed(!this.comparator.isReversed());
            this.buttonDirection.state = this.comparator.isReversed() ? 1 : 0;
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (GuiButton)this.method_37063((class_364)new GuiButton(this.field_2776 - 18, this.field_2800 + 5 + 36, 2, b -> {
            this.buttonSearchType.state = this.searchType = this.searchType + 1 & (this instanceof GuiCraftingTerminal ? 7 : 3);
            this.sendUpdate();
        }){

            @Override
            public void method_25359(class_4587 st, int mouseX, int mouseY, float pt) {
                if (this.field_22764) {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)GuiStorageTerminalBase.this.getGui());
                    this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                    this.method_25302(st, this.field_22760, this.field_22761, this.texX, this.texY + this.tile * 16, this.field_22758, this.field_22759);
                    if ((this.state & 1) > 0) {
                        this.method_25302(st, this.field_22760 + 1, this.field_22761 + 1, this.texX + 16, this.texY + this.tile * 16, this.field_22758 - 2, this.field_22759 - 2);
                    }
                    if ((this.state & 2) > 0) {
                        this.method_25302(st, this.field_22760 + 1, this.field_22761 + 1, this.texX + 16 + 14, this.texY + this.tile * 16, this.field_22758 - 2, this.field_22759 - 2);
                    }
                    if ((this.state & 4) > 0) {
                        this.method_25302(st, this.field_22760 + 1, this.field_22761 + 1, this.texX + 16 + 28, this.texY + this.tile * 16, this.field_22758 - 2, this.field_22759 - 2);
                    }
                }
            }
        });
        this.buttonCtrlMode = (GuiButton)this.method_37063((class_364)new GuiButton(this.field_2776 - 18, this.field_2800 + 5 + 54, 3, b -> {
            this.buttonCtrlMode.state = this.controllMode = (this.controllMode + 1) % ControllMode.VALUES.length;
            this.sendUpdate();
        }));
        this.updateSearch();
    }

    protected void updateSearch() {
        String searchString = this.searchField.method_1882();
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            ((ContainerStorageTerminal)this.method_17577()).itemListClientSorted.clear();
            boolean searchMod = false;
            if (searchString.startsWith("@")) {
                searchMod = true;
                searchString = searchString.substring(1);
            }
            Pattern m = null;
            try {
                m = Pattern.compile(searchString.toLowerCase(), 2);
            }
            catch (Throwable ignore) {
                try {
                    m = Pattern.compile(Pattern.quote(searchString.toLowerCase()), 2);
                }
                catch (Throwable __) {
                    return;
                }
            }
            boolean notDone = false;
            try {
                block6: for (int i = 0; i < ((ContainerStorageTerminal)this.method_17577()).itemListClient.size(); ++i) {
                    StoredItemStack is = ((ContainerStorageTerminal)this.method_17577()).itemListClient.get(i);
                    if (is == null || is.getStack() == null) continue;
                    String dspName = searchMod ? class_2378.field_11142.method_10221((Object)is.getStack().method_7909()).method_12836() : is.getStack().method_7964().getString();
                    notDone = true;
                    if (m.matcher(dspName.toLowerCase()).find()) {
                        this.addStackToClientList(is);
                        notDone = false;
                    }
                    if (!notDone) continue;
                    for (String lp : (List)tooltipCache.get((Object)is)) {
                        if (!m.matcher(lp).find()) continue;
                        this.addStackToClientList(is);
                        notDone = false;
                        continue block6;
                    }
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            Collections.sort(((ContainerStorageTerminal)this.method_17577()).itemListClientSorted, this.comparator);
            if (!this.searchLast.equals(searchString)) {
                ((ContainerStorageTerminal)this.method_17577()).scrollTo(0.0f);
                this.currentScroll = 0.0f;
                if ((this.searchType & 4) > 0) {
                    // empty if block
                }
                if ((this.searchType & 2) > 0) {
                    class_2487 nbt = new class_2487();
                    nbt.method_10582("s", searchString);
                    ((ContainerStorageTerminal)this.field_2797).sendMessage(nbt);
                }
                this.onUpdateSearch(searchString);
            } else {
                ((ContainerStorageTerminal)this.method_17577()).scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        ((ContainerStorageTerminal)this.method_17577()).itemListClientSorted.add(is);
    }

    public static class_1836 getTooltipFlag() {
        return class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934;
    }

    public void method_37432() {
        this.updateSearch();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        boolean flag = GLFW.glfwGetMouseButton((long)this.mc.method_22683().method_4490(), (int)0) != 0;
        int i = this.field_2776;
        int j = this.field_2800;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerStorageTerminal)this.method_17577()).scrollTo(this.currentScroll);
        }
        super.method_25394(matrices, mouseX, mouseY, partialTicks);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_308.method_24210();
        RenderSystem.setShaderTexture((int)0, (class_2960)creativeInventoryTabs);
        i = k;
        j = l;
        k = j1;
        this.method_25302(matrices, i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        matrices.method_22903();
        class_308.method_24211();
        this.slotIDUnderMouse = ((ContainerStorageTerminal)this.method_17577()).drawSlots(matrices, this, mouseX, mouseY);
        matrices.method_22909();
        this.method_2380(matrices, mouseX, mouseY);
        if (this.buttonSortingType.method_25367()) {
            this.method_25424(matrices, (class_2561)new class_2588("tooltip.toms_storage.sorting_" + this.buttonSortingType.state), mouseX, mouseY);
        }
        if (this.buttonSearchType.method_25367()) {
            this.method_25424(matrices, (class_2561)new class_2588("tooltip.toms_storage.search_" + this.buttonSearchType.state), mouseX, mouseY);
        }
        if (this.buttonCtrlMode.method_25367()) {
            this.method_30901(matrices, Arrays.stream(class_1074.method_4662((String)("tooltip.toms_storage.ctrlMode_" + this.buttonCtrlMode.state), (Object[])new Object[0]).split("\\\\")).map(class_2585::new).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    protected boolean needsScrollBars() {
        return ((ContainerStorageTerminal)this.method_17577()).itemListClientSorted.size() > this.rowCount * 9;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.slotIDUnderMouse > -1) {
            if (this.isPullOne(mouseButton)) {
                if (((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack != null && ((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() > 0L) {
                    for (int i = 0; i < ((ContainerStorageTerminal)this.method_17577()).itemList.size(); ++i) {
                        if (!((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.method_17577()).itemList.get(i))) continue;
                        this.storageSlotClick(((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), ContainerStorageTerminal.SlotAction.PULL_ONE, this.isTransferOne(mouseButton) ? 1 : 0);
                        return true;
                    }
                }
                return true;
            }
            if (this.pullHalf(mouseButton)) {
                if (!((ContainerStorageTerminal)this.field_2797).method_34255().method_7960()) {
                    this.storageSlotClick(class_1799.field_8037, GuiStorageTerminalBase.method_25441() ? ContainerStorageTerminal.SlotAction.GET_QUARTER : ContainerStorageTerminal.SlotAction.GET_HALF, 0);
                } else if (((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack != null && ((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() > 0L) {
                    for (int i = 0; i < ((ContainerStorageTerminal)this.method_17577()).itemList.size(); ++i) {
                        if (!((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.method_17577()).itemList.get(i))) continue;
                        this.storageSlotClick(((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), GuiStorageTerminalBase.method_25441() ? ContainerStorageTerminal.SlotAction.GET_QUARTER : ContainerStorageTerminal.SlotAction.GET_HALF, 0);
                        return true;
                    }
                }
            } else if (this.pullNormal(mouseButton)) {
                if (!((ContainerStorageTerminal)this.field_2797).method_34255().method_7960()) {
                    this.storageSlotClick(class_1799.field_8037, ContainerStorageTerminal.SlotAction.PULL_OR_PUSH_STACK, 0);
                } else if (((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack != null && ((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() > 0L) {
                    for (int i = 0; i < ((ContainerStorageTerminal)this.method_17577()).itemList.size(); ++i) {
                        if (!((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.method_17577()).itemList.get(i))) continue;
                        this.storageSlotClick(((ContainerStorageTerminal)this.method_17577()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), GuiStorageTerminalBase.method_25442() ? ContainerStorageTerminal.SlotAction.SHIFT_PULL : ContainerStorageTerminal.SlotAction.PULL_OR_PUSH_STACK, 0);
                        return true;
                    }
                }
            }
        } else if (GLFW.glfwGetKey((long)this.mc.method_22683().method_4490(), (int)32) != 0) {
            this.storageSlotClick(class_1799.field_8037, ContainerStorageTerminal.SlotAction.SPACE_CLICK, 0);
        } else if (mouseButton == 1 && this.method_2378(this.searchField.field_22760 - this.field_2776, this.searchField.field_22761 - this.field_2800, this.searchField.method_25368(), this.searchField.method_25364(), mouseX, mouseY)) {
            this.searchField.method_1852("");
        } else {
            if (this.searchField.method_25402(mouseX, mouseY, mouseButton)) {
                return true;
            }
            return super.method_25402(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    protected void storageSlotClick(class_1799 slotStack, ContainerStorageTerminal.SlotAction act, int mod) {
        class_2487 c = new class_2487();
        c.method_10566("s", (class_2520)slotStack.method_7953(new class_2487()));
        c.method_10569("a", act.ordinal());
        c.method_10567("m", (byte)mod);
        class_2487 msg = new class_2487();
        msg.method_10566("a", (class_2520)c);
        ((ContainerStorageTerminal)this.field_2797).sendMessage(msg);
    }

    public boolean isPullOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1 && GuiStorageTerminalBase.method_25442();
            }
            case RS: {
                return mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && !((ContainerStorageTerminal)this.field_2797).method_34255().method_7960();
            }
        }
        return false;
    }

    public boolean isTransferOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return GuiStorageTerminalBase.method_25442() && GuiStorageTerminalBase.method_25441();
            }
            case RS: {
                return GuiStorageTerminalBase.method_25442() && mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && GuiStorageTerminalBase.method_25442();
            }
        }
        return false;
    }

    public boolean pullHalf(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1;
            }
            case RS: {
                return mouseButton == 1;
            }
            case DEF: {
                return mouseButton == 1 && ((ContainerStorageTerminal)this.field_2797).method_34255().method_7960();
            }
        }
        return false;
    }

    public boolean pullNormal(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: 
            case RS: 
            case DEF: {
                return mouseButton == 0;
            }
        }
        return false;
    }

    private ControllMode ctrlm() {
        return ControllMode.VALUES[this.controllMode];
    }

    public final void renderItemInGui(class_4587 st, class_1799 stack, int x, int y, int mouseX, int mouseY, boolean hasBg, int color, boolean tooltip, String ... extraInfo) {
        if (stack != null) {
            if (!tooltip) {
                if (hasBg) {
                    GuiStorageTerminalBase.method_25294((class_4587)st, (int)x, (int)y, (int)16, (int)16, (int)(color | Integer.MIN_VALUE));
                }
                st.method_22904(0.0, 0.0, 32.0);
                class_327 font = this.field_22793;
                RenderSystem.enableDepthTest();
                this.field_22788.method_4010(stack, x, y);
                this.field_22788.method_4025(font, stack, x, y);
            } else if (mouseX >= x - 1 && mouseY >= y - 1 && mouseX < x + 17 && mouseY < y + 17) {
                int i;
                List list = this.method_25408(stack);
                if (extraInfo != null && extraInfo.length > 0) {
                    for (i = 0; i < extraInfo.length; ++i) {
                        list.add(new class_2585(extraInfo[i]));
                    }
                }
                for (i = 0; i < list.size(); ++i) {
                    class_5250 t2;
                    class_2561 t = (class_2561)list.get(i);
                    class_5250 class_52502 = t2 = t instanceof class_5250 ? (class_5250)t : t.method_27662();
                    if (i == 0) {
                        list.set(i, t2.method_27692(stack.method_7932().field_8908));
                        continue;
                    }
                    list.set(i, t2.method_27692(class_124.field_1080));
                }
                this.method_30901(st, list, mouseX, mouseY);
            }
        }
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public boolean method_25404(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.method_25419();
            return true;
        }
        return !this.searchField.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.searchField.method_20315() ? super.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean method_25400(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.method_25400(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.method_25400(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean method_25401(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (((ContainerStorageTerminal)this.field_2797).itemList.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = class_3532.method_15363((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((ContainerStorageTerminal)this.field_2797).scrollTo(this.currentScroll);
        return true;
    }

    public abstract class_2960 getGui();

    protected void method_2389(class_4587 st, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getGui());
        this.method_25302(st, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
    }

    protected void onUpdateSearch(String text) {
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    @Override
    public void receive(class_2487 tag) {
        ((ContainerStorageTerminal)this.field_2797).receiveClientTagPacket(tag);
        this.refreshItemList = true;
    }

    public class GuiButton
    extends class_4185 {
        protected int tile;
        protected int state;
        protected int texX;
        protected int texY;

        public GuiButton(int x, int y, int tile, class_4185.class_4241 pressable) {
            super(x, y, 16, 16, (class_2561)new class_2585(""), pressable);
            this.texX = 194;
            this.texY = 30;
            this.tile = tile;
        }

        public void setX(int i) {
            this.field_22760 = i;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float pt) {
            if (this.field_22764) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)GuiStorageTerminalBase.this.getGui());
                this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                this.method_25302(matrices, this.field_22760, this.field_22761, this.texX + this.state * 16, this.texY + this.tile * 16, this.field_22758, this.field_22759);
            }
        }
    }
}

