/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class StoredItemStack {
    private class_1799 stack;
    private long count;
    private static final String ITEM_COUNT_NAME = "c";
    private static final String ITEMSTACK_NAME = "s";

    public StoredItemStack(class_1799 stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    public StoredItemStack(class_1799 stack) {
        this.stack = stack.method_7972();
        this.stack.method_7939(1);
        this.count = stack.method_7947();
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public long getQuantity() {
        return this.count;
    }

    public class_1799 getActualStack() {
        class_1799 s = this.stack.method_7972();
        s.method_7939((int)this.count);
        return s;
    }

    public void writeToNBT(class_2487 tag) {
        tag.method_10544(ITEM_COUNT_NAME, this.getQuantity());
        tag.method_10566(ITEMSTACK_NAME, (class_2520)this.stack.method_7953(new class_2487()));
        tag.method_10562(ITEMSTACK_NAME).method_10551("Count");
    }

    public static StoredItemStack readFromNBT(class_2487 tag) {
        class_1799 cheat = class_1799.method_7915((class_2487)tag);
        tag.method_10562(ITEMSTACK_NAME).method_10567("Count", (byte)1);
        StoredItemStack stack = new StoredItemStack(!cheat.method_7960() ? cheat : class_1799.method_7915((class_2487)tag.method_10562(ITEMSTACK_NAME)), !cheat.method_7960() ? (long)cheat.method_7947() : tag.method_10537(ITEM_COUNT_NAME));
        return !stack.stack.method_7960() ? stack : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stack == null ? 0 : this.stack.method_7909().hashCode());
        result = 31 * result + (this.stack == null || !this.stack.method_7985() ? 0 : this.stack.method_7969().hashCode());
        return result;
    }

    public String getDisplayName() {
        return this.stack.method_7964().method_10851();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredItemStack other = (StoredItemStack)obj;
        return !(this.stack == null ? other.stack != null : !class_1799.method_7987((class_1799)this.stack, (class_1799)other.stack) || !class_1799.method_7975((class_1799)this.stack, (class_1799)other.stack));
    }

    public boolean equals(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !class_1799.method_7987((class_1799)this.stack, (class_1799)other.stack) || !class_1799.method_7975((class_1799)this.stack, (class_1799)other.stack));
    }

    public void grow(long c) {
        this.count += c;
    }

    public static enum SortingTypes {
        AMOUNT(ComparatorAmount::new),
        NAME(ComparatorName::new);

        public static final SortingTypes[] VALUES;
        private final Function<Boolean, IStoredItemStackComparator> factory;

        private SortingTypes(Function<Boolean, IStoredItemStackComparator> factory) {
            this.factory = factory;
        }

        public IStoredItemStackComparator create(boolean rev) {
            return this.factory.apply(rev);
        }

        static {
            VALUES = SortingTypes.values();
        }
    }

    public static interface IStoredItemStackComparator
    extends Comparator<StoredItemStack> {
        public boolean isReversed();

        public void setReversed(boolean var1);

        public int type();
    }

    public static class ComparatorName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in1.getDisplayName().compareTo(in2.getDisplayName());
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }

    public static class ComparatorAmount
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorAmount(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in2.getQuantity() > in1.getQuantity() ? 1 : (in1.getQuantity() == in2.getQuantity() ? in1.getStack().method_7964().method_10851().compareTo(in2.getStack().method_7964().method_10851()) : -1);
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }
}

