/*
 * Decompiled with CFR 0.152.
 */
package interactic;

import interactic.InteracticInit;
import interactic.ItemFilterScreen;
import interactic.util.InteracticConfig;
import interactic.util.ServerSideConfigEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class InteracticClientInit
implements ClientModInitializer {
    public static final class_304 PICKUP_ITEM = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.interactic.pickup_item", class_3675.field_16237.method_1444(), "key.categories.misc"));

    public void onInitializeClient() {
        FabricModelPredicateProviderRegistry.register((class_2960)new class_2960("enabled"), (stack, world, entity, seed) -> stack.method_7948().method_10577("Enabled") ? 1.0f : 0.0f);
        ScreenRegistry.register(InteracticInit.ITEM_FILTER_SCREEN_HANDLER, ItemFilterScreen::new);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (PICKUP_ITEM.method_1436()) {
                ClientPlayNetworking.send((class_2960)new class_2960("interactic", "pickup"), (class_2540)PacketByteBufs.empty());
                client.field_1724.method_6104(class_1268.field_5808);
            }
        });
        GuiRegistry guiRegistry = AutoConfig.getGuiRegistry(InteracticConfig.class);
        guiRegistry.registerAnnotationProvider((GuiProvider)new InteracticConfigGuiProvider(), new Class[]{ServerSideConfigEntry.class});
        guiRegistry.registerPredicateTransformer((list, s, field, o, o1, guiRegistryAccess) -> {
            ArrayList<TextListEntry> mutableList = new ArrayList<TextListEntry>(list);
            mutableList.add(ConfigEntryBuilder.create().startTextDescription(class_2561.method_30163((String)"This option disables all features in the Global category and removes them from the config screen after reboot. If you try to change them in the config file, they will be overwritten.")).build());
            return mutableList;
        }, field -> field.getName().equals("clientOnlyMode"));
        if (InteracticInit.getConfig().itemFilterEnabled) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("interactic", "set_filter_mode"), (client, handler, buf, responseSender) -> {
                boolean newMode = buf.readBoolean();
                client.execute(() -> {
                    class_437 patt3240$temp = client.field_1755;
                    if (!(patt3240$temp instanceof ItemFilterScreen)) {
                        return;
                    }
                    ItemFilterScreen screen = (ItemFilterScreen)patt3240$temp;
                    screen.blockMode = newMode;
                });
            });
        }
    }

    private static class InteracticConfigGuiProvider
    implements GuiProvider {
        private InteracticConfigGuiProvider() {
        }

        public List<AbstractConfigListEntry> get(String s, Field field, Object config, Object defaults, GuiRegistryAccess guiRegistryAccess) {
            ConfigEntryBuilder builder = ConfigEntryBuilder.create();
            if (((InteracticConfig)config).clientOnlyMode) {
                return Collections.emptyList();
            }
            try {
                return Collections.singletonList(builder.startBooleanToggle((class_2561)new class_2588(s), field.getBoolean(config)).setSaveConsumer(aBoolean -> this.trySetBoolean(field, config, (boolean)aBoolean)).setDefaultValue(field.getBoolean(defaults)).build());
            }
            catch (IllegalAccessException e) {
                return Collections.emptyList();
            }
        }

        private void trySetBoolean(Field f, Object o, boolean value) {
            try {
                f.setBoolean(o, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

