/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.MineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.MineshaftCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1160;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5314;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class MineshaftEndStructure
extends MineshaftStructure {
    public MineshaftEndStructure(Predicate<class_6834.class_6835<class_3111>> locationCheckPredicate, Function<class_6834.class_6835<class_3111>, Optional<class_6622<class_3111>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static MineshaftEndStructure create(MineshaftCodeConfig mineshaftCodeConfig) {
        MutableObject box = new MutableObject();
        MineshaftEndStructure finalInstance = new MineshaftEndStructure(arg_0 -> MineshaftEndStructure.lambda$create$0((Mutable)box, mineshaftCodeConfig, arg_0), arg_0 -> MineshaftEndStructure.lambda$create$1((Mutable)box, mineshaftCodeConfig, arg_0));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    @Override
    protected boolean isFeatureChunk(class_6834.class_6835<class_3111> context, MineshaftCodeConfig config) {
        boolean superCheck = super.isFeatureChunk(context, config);
        if (!superCheck) {
            return false;
        }
        int structureCheckRadius = 6;
        class_1923 chunkPos = context.comp_309();
        for (int curChunkX = chunkPos.field_9181 - structureCheckRadius; curChunkX <= chunkPos.field_9181 + structureCheckRadius; ++curChunkX) {
            for (int curChunkZ = chunkPos.field_9180 - structureCheckRadius; curChunkZ <= chunkPos.field_9180 + structureCheckRadius; ++curChunkZ) {
                for (class_3195<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.END_MINESHAFT_AVOID_STRUCTURE)) {
                    class_5314 structureConfig;
                    if (structureFeature == this || (structureConfig = context.comp_306().method_12109().method_28600(structureFeature)) == null || structureConfig.method_28803() <= 10) continue;
                    class_1923 chunkPos2 = structureFeature.method_27218(structureConfig, context.comp_308(), curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_9181 || curChunkZ != chunkPos2.field_9180) continue;
                    return false;
                }
            }
        }
        int minThickness = RepurposedStructures.RSAllConfig.RSMineshaftsConfig.misc.endMineshaftMinIslandThickness;
        if (minThickness == 0) {
            return true;
        }
        class_2338.class_2339 islandTopBottomThickness = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int xPos = chunkPos.method_8326();
        int zPos = chunkPos.method_8328();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_1160 offsetPos = direction.method_23955();
                offsetPos.method_4942(30.0f * (float)i);
                landHeight = this.getHeightAt(context.comp_306(), context.comp_311(), xPos + (int)offsetPos.method_4943(), zPos + (int)offsetPos.method_4947(), landHeight);
                if (landHeight - context.comp_306().method_33730() >= minThickness) continue;
                return false;
            }
        }
        this.analyzeLand(context.comp_306(), xPos, zPos, islandTopBottomThickness, context.comp_311());
        return islandTopBottomThickness.method_10260() >= minThickness;
    }

    private int getHeightAt(class_2794 chunkGenerator, class_5539 heightLimitView, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, chunkGenerator.method_18028(xPos, zPos, class_2902.class_2903.field_13194, heightLimitView));
        return landHeight;
    }

    private void analyzeLand(class_2794 chunkGenerator, int xPos, int zPos, class_2338.class_2339 islandTopBottomThickness, class_5539 heightLimitView) {
        class_4966 columnOfBlocks = chunkGenerator.method_26261(xPos, zPos, heightLimitView);
        int minY = chunkGenerator.method_33730();
        int rangeHeight = GeneralUtils.getMaxTerrainLimit(chunkGenerator);
        int maxY = minY + rangeHeight;
        class_2338.class_2339 currentPos = new class_2338.class_2339(xPos, maxY, zPos);
        boolean isInIsland = false;
        while (currentPos.method_10264() >= minY) {
            class_2680 state = columnOfBlocks.method_32892(currentPos.method_10264());
            if (!state.method_26215() && !isInIsland) {
                isInIsland = true;
                int topIslandY = Math.min(currentPos.method_10264(), islandTopBottomThickness.method_10263());
                islandTopBottomThickness.method_10103(topIslandY, islandTopBottomThickness.method_10264(), islandTopBottomThickness.method_10260());
            } else if (state.method_26215() && isInIsland || currentPos.method_10264() == minY) {
                int bottomIslandY = Math.max(currentPos.method_10264(), islandTopBottomThickness.method_10264());
                islandTopBottomThickness.method_10103(islandTopBottomThickness.method_10263(), bottomIslandY, islandTopBottomThickness.method_10260());
                break;
            }
            currentPos.method_10098(class_2350.field_11033);
        }
        if (!isInIsland) {
            islandTopBottomThickness.method_10103(0, 0, 0);
        }
        int thickness = islandTopBottomThickness.method_10263() - islandTopBottomThickness.method_10264();
        islandTopBottomThickness.method_10103(islandTopBottomThickness.method_10263(), islandTopBottomThickness.method_10264(), thickness);
    }

    public Optional<class_6622<class_3111>> generatePieces(class_6834.class_6835<class_3111> context, MineshaftCodeConfig config) {
        class_2338.class_2339 blockpos = new class_2338.class_2339(context.comp_309().method_8326(), 0, context.comp_309().method_8328());
        class_2338.class_2339 islandTopBottomThickness = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.analyzeLand(context.comp_306(), blockpos.method_10263(), blockpos.method_10260(), islandTopBottomThickness, context.comp_311());
        int minThickness = RepurposedStructures.RSAllConfig.RSMineshaftsConfig.misc.endMineshaftMinIslandThickness;
        int maxY = 53;
        int minY = 15;
        if (minThickness == 0) {
            blockpos.method_10104(class_2350.field_11036, 35);
        } else {
            class_2919 random = new class_2919((class_5819)new class_5820(0L));
            random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
            int structureStartHeight = random.nextInt(Math.max(islandTopBottomThickness.method_10260() - minThickness + 1, 1)) + islandTopBottomThickness.method_10264() + minThickness / 2;
            blockpos.method_10104(class_2350.field_11036, structureStartHeight);
            maxY = islandTopBottomThickness.method_10263() - 5;
            minY = islandTopBottomThickness.method_10264();
            if (maxY - minY <= 5) {
                minY = maxY - 5;
            }
        }
        class_2960 structureID = class_2378.field_16644.method_10221((Object)this);
        int finalMaxY = maxY;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(() -> (class_3785)context.comp_314().method_30530(class_2378.field_25917).method_10223(config.startPool), config.structureSize), structureID, (class_2338)blockpos, false, false, maxY, minY, (structurePiecesBuilder, pieces) -> {
            Optional<class_3790> highestPiece = pieces.stream().max(Comparator.comparingInt(p -> p.method_14935().method_35419()));
            int topY = highestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.method_14935().method_35419()).orElseGet(() -> ((class_2338.class_2339)blockpos).method_10264());
            if (topY > finalMaxY) {
                int newOffset = finalMaxY - topY;
                for (class_3443 piece : pieces) {
                    piece.method_14922(0, newOffset, 0);
                }
            }
        });
    }

    private static /* synthetic */ Optional lambda$create$1(Mutable box, MineshaftCodeConfig mineshaftCodeConfig, class_6834.class_6835 context) {
        return ((MineshaftEndStructure)((Object)box.getValue())).generatePieces((class_6834.class_6835<class_3111>)context, mineshaftCodeConfig);
    }

    private static /* synthetic */ boolean lambda$create$0(Mutable box, MineshaftCodeConfig mineshaftCodeConfig, class_6834.class_6835 context) {
        return ((MineshaftEndStructure)((Object)box.getValue())).isFeatureChunk((class_6834.class_6835<class_3111>)context, mineshaftCodeConfig);
    }
}

