/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.GenericJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3341;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5539;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class LandBasedEndStructure
extends GenericJigsawStructure {
    public LandBasedEndStructure(Predicate<class_6834.class_6835<class_3111>> locationCheckPredicate, Function<class_6834.class_6835<class_3111>, Optional<class_6622<class_3111>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static LandBasedEndStructure create(GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig) {
        MutableObject box = new MutableObject();
        LandBasedEndStructure finalInstance = new LandBasedEndStructure(arg_0 -> LandBasedEndStructure.lambda$create$0((Mutable)box, genericJigsawStructureCodeConfig, arg_0), arg_0 -> LandBasedEndStructure.lambda$create$1((Mutable)box, genericJigsawStructureCodeConfig, arg_0));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    @Override
    protected boolean isFeatureChunk(class_6834.class_6835<class_3111> context, GenericJigsawStructureCodeConfig config) {
        return LandBasedEndStructure.getTerrainHeight(context.comp_309(), context.comp_306(), context.comp_311()) >= Math.min(GeneralUtils.getMaxTerrainLimit(context.comp_306()), 50);
    }

    private static int getTerrainHeight(class_1923 chunkPos1, class_2794 chunkGenerator, class_5539 heightLimitView) {
        int xPos = chunkPos1.field_9181 << 4;
        int zPos = chunkPos1.field_9180 << 4;
        int height = chunkGenerator.method_18028(xPos, zPos, class_2902.class_2903.field_13194, heightLimitView);
        class_2338 pos = new class_2338(xPos, GeneralUtils.getMaxTerrainLimit(chunkGenerator), zPos);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)pos).method_10104(direction, 16);
            height = Math.min(height, chunkGenerator.method_18028(mutable.method_10263(), mutable.method_10260(), class_2902.class_2903.field_13194, heightLimitView));
        }
        return height;
    }

    @Override
    public Optional<class_6622<class_3111>> generatePieces(class_6834.class_6835<class_3111> context, GenericJigsawStructureCodeConfig config) {
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), config.fixedYSpawn, context.comp_309().method_8328());
        class_2960 structureID = class_2378.field_16644.method_10221((Object)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(() -> (class_3785)context.comp_314().method_30530(class_2378.field_25917).method_10223(config.startPool), config.structureSize), structureID, blockpos, config.useHeightmap, config.useHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            ((class_3790)pieces.get(0)).method_14922(0, config.centerOffset, 0);
            class_3341 box = ((class_3790)pieces.get(0)).method_14935();
            class_2338 centerPos = new class_2338((class_2382)box.method_22874());
            int radius = (int)Math.sqrt(box.method_14659().method_10263() * box.method_14659().method_10263() + box.method_14659().method_10260() * box.method_14659().method_10260()) / 2;
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = context.comp_306().method_18028(centerPos.method_10263() + xOffset, centerPos.method_10260() + zOffset, class_2902.class_2903.field_13194, context.comp_311());
                    landHeights.add(landHeight);
                }
            }
            int avgHeight = (int)Math.max(landHeights.stream().mapToInt(Integer::intValue).average().orElse(0.0), 50.0);
            int parentHeight = ((class_3790)pieces.get(0)).method_14935().method_35416();
            int offsetAmount = avgHeight - parentHeight + config.centerOffset;
            pieces.forEach(child -> child.method_14922(0, offsetAmount, 0));
            GeneralUtils.centerAllPieces(centerPos, pieces);
        });
    }

    private static /* synthetic */ Optional lambda$create$1(Mutable box, GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig, class_6834.class_6835 context) {
        return ((LandBasedEndStructure)((Object)box.getValue())).generatePieces((class_6834.class_6835<class_3111>)context, genericJigsawStructureCodeConfig);
    }

    private static /* synthetic */ boolean lambda$create$0(Mutable box, GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig, class_6834.class_6835 context) {
        return ((LandBasedEndStructure)((Object)box.getValue())).isFeatureChunk((class_6834.class_6835<class_3111>)context, genericJigsawStructureCodeConfig);
    }
}

