/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.GenericJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5314;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class GenericJigsawStructure
extends AbstractBaseStructure<class_3111> {
    public GenericJigsawStructure(Predicate<class_6834.class_6835<class_3111>> locationCheckPredicate, Function<class_6834.class_6835<class_3111>, Optional<class_6622<class_3111>>> pieceCreationPredicate) {
        super(class_3111.field_24893, locationCheckPredicate, pieceCreationPredicate);
    }

    public static GenericJigsawStructure create(GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig) {
        MutableObject box = new MutableObject();
        GenericJigsawStructure finalInstance = new GenericJigsawStructure(arg_0 -> GenericJigsawStructure.lambda$create$0((Mutable)box, genericJigsawStructureCodeConfig, arg_0), arg_0 -> GenericJigsawStructure.lambda$create$1((Mutable)box, genericJigsawStructureCodeConfig, arg_0));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(class_6834.class_6835<class_3111> context, GenericJigsawStructureCodeConfig config) {
        int curChunkZ;
        int curChunkX;
        class_1923 chunkPos = context.comp_309();
        if (!(context.comp_307() instanceof class_1973)) {
            for (curChunkX = chunkPos.field_9181 - config.biomeRange; curChunkX <= chunkPos.field_9181 + config.biomeRange; ++curChunkX) {
                for (curChunkZ = chunkPos.field_9180 - config.biomeRange; curChunkZ <= chunkPos.field_9180 + config.biomeRange; ++curChunkZ) {
                    int yValue = config.useHeightmap ? config.fixedYSpawn + context.comp_306().method_20402(curChunkX << 4, curChunkZ << 4, class_2902.class_2903.field_13194, context.comp_311()) : config.fixedYSpawn;
                    class_1959 biome = context.comp_307().method_38109(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.comp_306().method_38276());
                    if (context.comp_312().test(biome)) continue;
                    return false;
                }
            }
        }
        for (curChunkX = chunkPos.field_9181 - config.structureBlacklistRange; curChunkX <= chunkPos.field_9181 + config.structureBlacklistRange; ++curChunkX) {
            for (curChunkZ = chunkPos.field_9180 - config.structureBlacklistRange; curChunkZ <= chunkPos.field_9180 + config.structureBlacklistRange; ++curChunkZ) {
                for (RSStructureTagMap.STRUCTURE_TAGS tag : config.avoidStructuresSet) {
                    for (class_3195<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag)) {
                        class_5314 structureConfig;
                        if (structureFeature == this || (structureConfig = context.comp_306().method_12109().method_28600(structureFeature)) == null || structureConfig.method_28803() <= 8) continue;
                        class_1923 chunkPos2 = structureFeature.method_27218(structureConfig, context.comp_308(), curChunkX, curChunkZ);
                        if (curChunkX != chunkPos2.field_9181 || curChunkZ != chunkPos2.field_9180) continue;
                        return false;
                    }
                }
            }
        }
        if (config.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX2 = chunkPos.field_9181 - config.terrainHeightRadius; curChunkX2 <= chunkPos.field_9181 + config.terrainHeightRadius; ++curChunkX2) {
                for (int curChunkZ2 = chunkPos.field_9180 - config.terrainHeightRadius; curChunkZ2 <= chunkPos.field_9180 + config.terrainHeightRadius; ++curChunkZ2) {
                    int height = context.comp_306().method_16397((curChunkX2 << 4) + 7, (curChunkZ2 << 4) + 7, class_2902.class_2903.field_13194, context.comp_311());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= config.minHeightLimit) continue;
                    return false;
                }
            }
            if (maxTerrainHeight - minTerrainHeight > config.allowTerrainHeightRange) {
                return false;
            }
        }
        if (config.cannotSpawnInWater) {
            class_2338 centerOfChunk = chunkPos.method_33943(0);
            int landHeight = context.comp_306().method_18028(centerOfChunk.method_10263(), centerOfChunk.method_10260(), class_2902.class_2903.field_13194, context.comp_311());
            class_4966 columnOfBlocks = context.comp_306().method_26261(centerOfChunk.method_10263(), centerOfChunk.method_10260(), context.comp_311());
            class_2680 topBlock = columnOfBlocks.method_32892(centerOfChunk.method_10264() + landHeight);
            if (!topBlock.method_26227().method_15769()) {
                return false;
            }
        }
        return true;
    }

    public Optional<class_6622<class_3111>> generatePieces(class_6834.class_6835<class_3111> context, GenericJigsawStructureCodeConfig config) {
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), config.fixedYSpawn, context.comp_309().method_8328());
        class_2960 structureID = class_2378.field_16644.method_10221((Object)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(() -> (class_3785)context.comp_314().method_30530(class_2378.field_25917).method_10223(config.startPool), config.structureSize), structureID, blockpos, config.useHeightmap, config.useHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBounds, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            ((class_3790)pieces.get(0)).method_14922(0, config.centerOffset, 0);
        });
    }

    private static /* synthetic */ Optional lambda$create$1(Mutable box, GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig, class_6834.class_6835 context) {
        return ((GenericJigsawStructure)((Object)box.getValue())).generatePieces((class_6834.class_6835<class_3111>)context, genericJigsawStructureCodeConfig);
    }

    private static /* synthetic */ boolean lambda$create$0(Mutable box, GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig, class_6834.class_6835 context) {
        return ((GenericJigsawStructure)((Object)box.getValue())).isFeatureChunk((class_6834.class_6835<class_3111>)context, genericJigsawStructureCodeConfig);
    }
}

