/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.BuriableStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3341;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class BuriableStructure
extends AbstractBaseStructure<class_3111> {
    public BuriableStructure(Predicate<class_6834.class_6835<class_3111>> locationCheckPredicate, Function<class_6834.class_6835<class_3111>, Optional<class_6622<class_3111>>> pieceCreationPredicate) {
        super(class_3111.field_24893, locationCheckPredicate, pieceCreationPredicate);
    }

    public static BuriableStructure create(BuriableStructureCodeConfig buriableStructureCodeConfig) {
        MutableObject box = new MutableObject();
        BuriableStructure finalInstance = new BuriableStructure(arg_0 -> BuriableStructure.lambda$create$0((Mutable)box, buriableStructureCodeConfig, arg_0), arg_0 -> BuriableStructure.lambda$create$1((Mutable)box, buriableStructureCodeConfig, arg_0));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(class_6834.class_6835<class_3111> context, BuriableStructureCodeConfig config) {
        if (config.cannotSpawnInWater) {
            class_2338 cornerOfSpawnChunk = context.comp_309().method_8323();
            int landHeight = context.comp_306().method_18028(cornerOfSpawnChunk.method_10263(), cornerOfSpawnChunk.method_10260(), class_2902.class_2903.field_13194, context.comp_311());
            class_4966 columnOfBlocks = context.comp_306().method_26261(cornerOfSpawnChunk.method_10263(), cornerOfSpawnChunk.method_10260(), context.comp_311());
            class_2680 topBlock = columnOfBlocks.method_32892(cornerOfSpawnChunk.method_10264() + landHeight);
            return topBlock.method_26227().method_15769();
        }
        return true;
    }

    public Optional<class_6622<class_3111>> generatePieces(class_6834.class_6835<class_3111> context, BuriableStructureCodeConfig config) {
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), context.comp_306().method_16398(), context.comp_309().method_8328());
        class_2960 structureID = class_2378.field_16644.method_10221((Object)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(() -> (class_3785)context.comp_314().method_30530(class_2378.field_25917).method_10223(config.startPool), 11), structureID, blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            class_2902.class_2903 heightMapToUse = config.onLand ? class_2902.class_2903.field_13194 : class_2902.class_2903.field_13195;
            class_3341 box = ((class_3790)pieces.get(0)).method_14935();
            int highestLandPos = context.comp_306().method_16397(box.method_35415(), box.method_35417(), heightMapToUse, context.comp_311());
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_16397(box.method_35415(), box.method_35420(), heightMapToUse, context.comp_311()));
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_16397(box.method_35418(), box.method_35417(), heightMapToUse, context.comp_311()));
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_16397(box.method_35418(), box.method_35420(), heightMapToUse, context.comp_311()));
            if (!config.onLand) {
                int maxHeightForSubmerging = context.comp_306().method_16398() - box.method_14660();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            }
            class_2919 random = new class_2919((class_5819)new class_5820(0L));
            random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
            structurePiecesBuilder.method_38718((Random)random, highestLandPos - (config.offsetAmount + 1), highestLandPos - config.offsetAmount);
        });
    }

    private static /* synthetic */ Optional lambda$create$1(Mutable box, BuriableStructureCodeConfig buriableStructureCodeConfig, class_6834.class_6835 context) {
        return ((BuriableStructure)((Object)box.getValue())).generatePieces((class_6834.class_6835<class_3111>)context, buriableStructureCodeConfig);
    }

    private static /* synthetic */ boolean lambda$create$0(Mutable box, BuriableStructureCodeConfig buriableStructureCodeConfig, class_6834.class_6835 context) {
        return ((BuriableStructure)((Object)box.getValue())).isFeatureChunk((class_6834.class_6835<class_3111>)context, buriableStructureCodeConfig);
    }
}

