/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.mixin.resources.NamespaceResourceManagerAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.resources.ReloadableResourceManagerImplAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3294;
import net.minecraft.class_3300;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3499;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3748;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5000;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5539;

public final class GeneralUtils {
    private static final Map<class_2680, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<class_2680, Boolean>();

    private GeneralUtils() {
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(class_1922 world, class_2338 pos, class_2680 state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> class_2248.method_9614((class_265)stateIn.method_26201(world, pos)));
    }

    public static class_2680 orientateChest(class_5425 blockView, class_2338 blockPos, class_2680 blockState) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2350 wallDirection = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)blockPos).method_10098(facing);
            if (!GeneralUtils.isFullCube((class_1922)blockView, (class_2338)mutable, blockView.method_8320((class_2338)mutable))) continue;
            wallDirection = facing;
            mutable.method_10104(facing.method_10153(), 2);
            if (blockView.method_8320((class_2338)mutable).method_26207().method_15799()) continue;
            break;
        }
        return (class_2680)blockState.method_11657((class_2769)class_2383.field_11177, (Comparable)wallDirection.method_10153());
    }

    public static boolean isBlacklistedForWorld(class_5425 currentWorld, class_2960 worldgenObjectID) {
        class_2960 worldID = currentWorld.method_8410().method_27983().method_29177();
        boolean allowInDim = ((List)BiomeDimensionAllowDisallow.DIMENSION_DISALLOW.getOrDefault(worldgenObjectID, new ArrayList())).stream().noneMatch(pattern -> pattern.matcher(worldID.toString()).find());
        if (!allowInDim && ((List)BiomeDimensionAllowDisallow.DIMENSION_ALLOW.getOrDefault(worldgenObjectID, new ArrayList())).stream().anyMatch(pattern -> pattern.matcher(worldID.toString()).find())) {
            allowInDim = true;
        }
        return !allowInDim;
    }

    public static void addToBiome(String modificationName, Predicate<BiomeSelectionContext> selectorPredicate, Consumer<BiomeModificationContext> biomeAdditionConsumer) {
        BiomeModifications.create((class_2960)new class_2960("repurposed_structures", modificationName)).add(ModificationPhase.ADDITIONS, selectorPredicate, biomeAdditionConsumer);
    }

    public static class_1799 enchantRandomly(Random random, class_1799 itemToEnchant, float chance) {
        List list;
        if (random.nextFloat() < chance && !(list = class_2378.field_11160.method_10220().filter(class_1887::method_25950).filter(enchantmentToCheck -> enchantmentToCheck.method_8192(itemToEnchant)).collect(Collectors.toList())).isEmpty()) {
            class_1887 enchantment = (class_1887)list.get(random.nextInt(list.size()));
            int enchantmentLevel = random.nextInt(class_3532.method_15395((Random)random, (int)enchantment.method_8187(), (int)enchantment.method_8183()) + 1);
            itemToEnchant.method_7978(enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(class_2794 chunkGenerator) {
        return chunkGenerator.method_33730() + chunkGenerator.method_12104();
    }

    public static class_2338 getHighestLand(class_2794 chunkGenerator, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 20, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView);
        while (mutable.method_10264() > chunkGenerator.method_16398()) {
            class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
            if (!currentBlockstate.method_26225()) {
                mutable.method_10098(class_2350.field_11033);
                continue;
            }
            if (blockView.method_32892(mutable.method_10264() + 3).method_26207() == class_3614.field_15959 && (canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225())) {
                return mutable;
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return mutable;
    }

    public static class_2338 getLowestLand(class_2794 chunkGenerator, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), chunkGenerator.method_16398() + 1, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView);
        class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
        while (mutable.method_10264() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 20) {
            if ((canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225()) && blockView.method_32892(mutable.method_10264() + 1).method_26207() == class_3614.field_15959 && blockView.method_32892(mutable.method_10264() + 5).method_26207() == class_3614.field_15959) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            mutable.method_10098(class_2350.field_11036);
            currentBlockstate = blockView.method_32892(mutable.method_10264());
        }
        return mutable.method_10103(mutable.method_10263(), chunkGenerator.method_16398(), mutable.method_10260());
    }

    public static int getFirstLandYFromPos(class_4538 worldView, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10101((class_2382)pos);
        class_2791 currentChunk = worldView.method_22350((class_2338)mutable);
        class_2680 currentState = currentChunk.method_8320((class_2338)mutable);
        while (mutable.method_10264() >= worldView.method_31607() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.method_10098(class_2350.field_11033);
            currentState = currentChunk.method_8320((class_2338)mutable);
        }
        return mutable.method_10264();
    }

    private static boolean isReplaceableByStructures(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26207().method_15797() || blockState.method_26207().method_15800();
    }

    public static void centerAllPieces(class_2338 targetPos, List<? extends class_3443> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        class_2338 structureCenter = pieces.get(0).method_14935().method_22874();
        int xOffset = targetPos.method_10263() - structureCenter.method_10263();
        int zOffset = targetPos.method_10260() - structureCenter.method_10260();
        for (class_3443 class_34432 : pieces) {
            class_34432.method_14922(xOffset, 0, zOffset);
        }
    }

    public static boolean canJigsawsAttach(class_3499.class_3501 jigsaw1, class_3499.class_3501 jigsaw2) {
        class_5000 prop1 = (class_5000)jigsaw1.field_15596.method_11654((class_2769)class_3748.field_23262);
        class_5000 prop2 = (class_5000)jigsaw2.field_15596.method_11654((class_2769)class_3748.field_23262);
        String joint = jigsaw1.field_15595.method_10558("joint");
        if (joint.isEmpty()) {
            joint = prop1.method_26426().method_10166().method_10179() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.method_26426() == prop2.method_26426().method_10153() && (isRollable || prop1.method_26428() == prop2.method_26428()) && jigsaw1.field_15595.method_10558("target").equals(jigsaw2.field_15595.method_10558("name"));
    }

    public static boolean inStructureBounds(class_5281 level, class_4076 refSectionPos, RSStructureTagMap.STRUCTURE_TAGS structureTag) {
        class_2791 refChunk = level.method_22342(refSectionPos.method_18674(), refSectionPos.method_18687(), class_2806.field_16422);
        Long2ObjectOpenHashMap startsChunks = new Long2ObjectOpenHashMap();
        for (class_3195<?> structure : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)structureTag)) {
            LongSet longset = refChunk.method_12180(structure);
            LongIterator longIterator = longset.iterator();
            while (longIterator.hasNext()) {
                long longPos = (Long)longIterator.next();
                class_2791 startsChunk = startsChunks.computeIfAbsent(longPos, l -> {
                    class_4076 startsSectionPos = class_4076.method_18681((class_1923)new class_1923(longPos), (int)level.method_32891());
                    return level.method_22342(startsSectionPos.method_18674(), startsSectionPos.method_18687(), class_2806.field_16423);
                });
                class_3449 structureStart = startsChunk.method_12181(structure);
                if (structureStart == null || !structureStart.method_16657()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<InputStream> getAllFileStreams(class_3300 resourceManager, class_2960 fileID) throws IOException {
        ArrayList<InputStream> fileStreams = new ArrayList<InputStream>();
        class_3294 namespaceResourceManager = ((ReloadableResourceManagerImplAccessor)resourceManager).repurposedstructures_getNamespacedPacks().get(fileID.method_12836());
        List<class_3262> allResourcePacks = ((NamespaceResourceManagerAccessor)namespaceResourceManager).repurposedstructures_getFallbacks();
        for (class_3262 resourcePack : allResourcePacks) {
            InputStream inputStream;
            if (!resourcePack.method_14411(class_3264.field_14190, fileID) || (inputStream = ((NamespaceResourceManagerAccessor)namespaceResourceManager).repurposedstructures_callGetWrappedResource(fileID, resourcePack)) == null) continue;
            fileStreams.add(inputStream);
        }
        return fileStreams;
    }

    public static Map<class_2960, List<JsonElement>> getAllDatapacksJSONElement(class_3300 resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<class_2960, List<JsonElement>> map = new HashMap<class_2960, List<JsonElement>>();
        int dataTypeLength = dataType.length() + 1;
        for (class_2960 fileIDWithExtension : resourceManager.method_14488(dataType, fileString -> fileString.endsWith(".json"))) {
            String identifierPath = fileIDWithExtension.method_12832();
            class_2960 fileID = new class_2960(fileIDWithExtension.method_12836(), identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                for (InputStream fileStream : GeneralUtils.getAllFileStreams(resourceManager, fileIDWithExtension)) {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                        JsonElement countsJSONElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                        if (countsJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(countsJSONElement);
                            continue;
                        }
                        RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)dataType, (Object)fileID, (Object)fileIDWithExtension);
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, (Object)fileIDWithExtension, (Object)exception);
            }
        }
        return map;
    }
}

