/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5138;
import net.minecraft.class_5483;
import net.minecraft.class_6012;

public final class MobSpawningOverTime {
    public static final Map<class_1311, Map<class_3195<?>, List<class_5483.class_1964>>> REPLACE_MOB_SPAWNING = new HashMap();
    public static final Map<class_1311, Map<class_3195<?>, List<class_5483.class_1964>>> APPEND_MOB_SPAWNING = new HashMap();

    private MobSpawningOverTime() {
    }

    public static void setupMobSpawningMaps() {
        Arrays.stream(class_1311.values()).forEach(group -> REPLACE_MOB_SPAWNING.put((class_1311)group, new HashMap()));
        Arrays.stream(class_1311.values()).forEach(group -> APPEND_MOB_SPAWNING.put((class_1311)group, new HashMap()));
        MobSpawningOverTime.setupMap(REPLACE_MOB_SPAWNING, RepurposedStructures.omegaMobSpawnConfig.replaceMobSpawns, "replace mob spawning");
        MobSpawningOverTime.setupMap(APPEND_MOB_SPAWNING, RepurposedStructures.omegaMobSpawnConfig.appendMobSpawns, "append mob spawning");
    }

    private static void setupMap(Map<class_1311, Map<class_3195<?>, List<class_5483.class_1964>>> mapToFillWithMobSpawns, Map<String, List<PublicMobSpawnEntry>> configMap, String errorMsg) {
        for (Map.Entry<String, List<PublicMobSpawnEntry>> configMapEntry : configMap.entrySet()) {
            if (!configMapEntry.getKey().equals("all") && !configMapEntry.getKey().contains("repurposed_structures")) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Found key that is not a repurposed structure's structure in {} config: {} Skipping that entry...", (Object)errorMsg, (Object)configMapEntry.getKey());
                continue;
            }
            if (configMapEntry.getKey().equals("all")) {
                RSStructures.RS_STRUCTURES.forEach((key, value) -> {
                    for (PublicMobSpawnEntry spawnEntry : (List)configMapEntry.getValue()) {
                        Optional entityType = class_2378.field_11145.method_17966(new class_2960(spawnEntry.type));
                        if (entityType.isEmpty()) {
                            if (!spawnEntry.logErrorIfNotFound) continue;
                            RepurposedStructures.LOGGER.warn("Repurposed Structures (first): Unknown EntityType {} was found in the {} config. Skipping that entry...", (Object)spawnEntry.type, (Object)errorMsg);
                            continue;
                        }
                        class_5483.class_1964 entryToAdd = new class_5483.class_1964((class_1299)entityType.get(), spawnEntry.weight, spawnEntry.minGroupSize, spawnEntry.maxGroupSize);
                        Map structureMobMap = (Map)mapToFillWithMobSpawns.get(entryToAdd.field_9389.method_5891());
                        if (structureMobMap.containsKey(key)) {
                            ((List)structureMobMap.get(key)).add(entryToAdd);
                            continue;
                        }
                        structureMobMap.put(key, new ArrayList());
                        ((List)structureMobMap.get(key)).add(entryToAdd);
                    }
                });
                continue;
            }
            class_3195 structureFeature = (class_3195)class_2378.field_16644.method_10223(new class_2960(configMapEntry.getKey()));
            if (structureFeature == null) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)configMapEntry.getKey(), (Object)errorMsg);
                continue;
            }
            for (PublicMobSpawnEntry spawnEntry : configMapEntry.getValue()) {
                Optional entityType = class_2378.field_11145.method_17966(new class_2960(spawnEntry.type));
                if (entityType.isEmpty()) {
                    if (!spawnEntry.logErrorIfNotFound) continue;
                    RepurposedStructures.LOGGER.warn("Repurposed Structures (second): Unknown EntityType {} was found in the {} config. Skipping that entry...", (Object)spawnEntry.type, (Object)errorMsg);
                    continue;
                }
                class_5483.class_1964 entryToAdd = new class_5483.class_1964((class_1299)entityType.get(), spawnEntry.weight, spawnEntry.minGroupSize, spawnEntry.maxGroupSize);
                Map<class_3195<?>, List<class_5483.class_1964>> structureMobMap = mapToFillWithMobSpawns.get(entryToAdd.field_9389.method_5891());
                if (structureMobMap.containsKey(structureFeature)) {
                    structureMobMap.get(structureFeature).add(entryToAdd);
                    continue;
                }
                structureMobMap.put(structureFeature, new ArrayList());
                structureMobMap.get(structureFeature).add(entryToAdd);
            }
        }
    }

    public static class_6012<class_5483.class_1964> getStructureSpawns(class_1959 biome, class_5138 accessor, class_1311 spawnGroup, class_2338 pos) {
        for (Map.Entry<class_3195<?>, List<class_5483.class_1964>> structureEntry : REPLACE_MOB_SPAWNING.get(spawnGroup).entrySet()) {
            if (structureEntry.getValue().isEmpty() || !accessor.method_28388(pos, structureEntry.getKey()).method_16657()) continue;
            return class_6012.method_34988(structureEntry.getValue());
        }
        ArrayList appendedSpawn = null;
        for (Map.Entry<class_3195<?>, List<class_5483.class_1964>> structureEntry : APPEND_MOB_SPAWNING.get(spawnGroup).entrySet()) {
            if (structureEntry.getValue().isEmpty() || !accessor.method_28388(pos, structureEntry.getKey()).method_16657()) continue;
            if (appendedSpawn == null) {
                appendedSpawn = new ArrayList(biome.method_30966().method_31004(spawnGroup).method_34994());
            }
            appendedSpawn.addAll(structureEntry.getValue());
        }
        return appendedSpawn == null ? null : class_6012.method_34988(appendedSpawn);
    }

    public static class PublicMobSpawnEntry {
        public final String type;
        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public final boolean logErrorIfNotFound;

        public PublicMobSpawnEntry(String type, int weight, int minGroupSize, int maxGroupSize, boolean logErrorIfNotFound) {
            this.type = type;
            this.weight = weight;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.logErrorIfNotFound = logErrorIfNotFound;
        }

        public PublicMobSpawnEntry(String type, int weight, int minGroupSize, int maxGroupSize) {
            this(type, weight, minGroupSize, maxGroupSize, true);
        }
    }
}

