/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Bastions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Cities;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Fortresses;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Igloos;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mansions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mineshafts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Outposts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Pyramids;
import com.telepathicgrunt.repurposedstructures.biomeinjection.RuinedPortals;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Ruins;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Shipwrecks;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Strongholds;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Temples;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Villages;
import com.telepathicgrunt.repurposedstructures.biomeinjection.WitchHuts;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_5312;
import net.minecraft.class_5321;

public final class BiomeInjection {
    private BiomeInjection() {
    }

    public static void addStructureToBiomes(Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap, class_2378<class_1959> biomeRegistry) {
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Bastions::addBastions);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Cities::addCities);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Fortresses::addJungleFortress);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Igloos::addIgloos);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Mansions::addMansions);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Mineshafts::addMineshafts);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Outposts::addOutposts);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Pyramids::addPyramids);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, RuinedPortals::addRuinedPortals);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Ruins::addRuins);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Shipwrecks::addShipwrecks);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Strongholds::addStrongholds);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Temples::addTemples);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Villages::addVillages);
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, WitchHuts::addWitchHuts);
    }

    private static void addConfiguredStructureEntries(Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap, class_2378<class_1959> biomeRegistry, Consumer<BiomeInjectionHelper> structureAddition) {
        for (Map.Entry biomeEntry : biomeRegistry.method_29722()) {
            structureAddition.accept(new BiomeInjectionHelper(biomeEntry, biomeRegistry, structureToMultiMap));
        }
    }

    public static class BiomeInjectionHelper {
        public final class_1959 biome;
        public final class_5321<class_1959> biomeKey;
        public final class_2378<class_1959> biomeRegistry;
        public final Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap;

        public BiomeInjectionHelper(Map.Entry<class_5321<class_1959>, class_1959> biomeEntry, class_2378<class_1959> biomeRegistry, Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap) {
            this.biome = biomeEntry.getValue();
            this.biomeKey = biomeEntry.getKey();
            this.biomeRegistry = biomeRegistry;
            this.structureToMultiMap = structureToMultiMap;
        }

        public class_5321<class_1959> getBiomeKey() {
            return (class_5321)this.biomeRegistry.method_29113((Object)this.biome).get();
        }

        public void addStructure(class_5312<?, ?> configuredStructureFeature) {
            this.structureToMultiMap.computeIfAbsent(configuredStructureFeature.field_24835, f -> HashMultimap.create());
            this.structureToMultiMap.get(configuredStructureFeature.field_24835).put(configuredStructureFeature, this.biomeKey);
        }

        public void removeStructure(class_5312<?, ?> configuredStructureFeature) {
            Multimap<class_5312<?, ?>, class_5321<class_1959>> structureFeatureResourceKeyMultimap = this.structureToMultiMap.get(configuredStructureFeature.field_24835);
            structureFeatureResourceKeyMultimap.remove(configuredStructureFeature, this.biomeKey);
        }
    }
}

