/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.telepathicgrunt.repurposedstructures.biomeinjection.BiomeInjection;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Dungeons;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Wells;
import com.telepathicgrunt.repurposedstructures.configs.RSAllConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSAllowDisallowOmegaConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSNaturalMobSpawningOmegaConfig;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.misc.MobMapTrades;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawningOverTime;
import com.telepathicgrunt.repurposedstructures.misc.PoolAdditionMerger;
import com.telepathicgrunt.repurposedstructures.misc.StructurePieceCountsManager;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructureSettingsAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSPlacements;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import draylar.omegaconfig.OmegaConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3264;
import net.minecraft.class_5311;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepurposedStructures
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "repurposed_structures";
    public static MobSpawnerManager mobSpawnerManager = new MobSpawnerManager();
    public static StructurePieceCountsManager structurePieceCountsManager = new StructurePieceCountsManager();
    public static RSAllConfig RSAllConfig = null;
    public static final RSAllowDisallowOmegaConfig omegaBiomeDimConfig = (RSAllowDisallowOmegaConfig)OmegaConfig.register(RSAllowDisallowOmegaConfig.class);
    public static final RSNaturalMobSpawningOmegaConfig omegaMobSpawnConfig = (RSNaturalMobSpawningOmegaConfig)OmegaConfig.register(RSNaturalMobSpawningOmegaConfig.class);
    public static boolean initialized = false;

    public void onInitialize() {
        AutoConfig.register(RSAllConfig.class, JanksonConfigSerializer::new);
        RSAllConfig = (RSAllConfig)AutoConfig.getConfigHolder(RSAllConfig.class).getConfig();
        RSPlacements.registerPlacements();
        RSFeatures.registerFeatures();
        RSProcessors.registerProcessors();
        RSPredicates.registerPredicates();
        RSStructures.registerStructures();
        RSStructureTagMap.setupTags();
        RSConfiguredFeatures.registerConfiguredFeatures();
        RSConfiguredFeatures.registerPlacedFeatures();
        RSConfiguredStructures.registerConfiguredStructures();
        BiomeDimensionAllowDisallow.setupAllowDisallowMaps();
        MobSpawningOverTime.setupMobSpawningMaps();
        RepurposedStructures.setupBiomeModifications();
        RepurposedStructures.allowStructureSpawningPerDimension();
        PoolAdditionMerger.mergeAdditionPools();
        MobMapTrades.addMapTrades();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)mobSpawnerManager);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)structurePieceCountsManager);
        initialized = true;
    }

    public static void allowStructureSpawningPerDimension() {
        class_2960 runAfterFabricAPIPhase = new class_2960(MODID, "run_after_fabric_api");
        ServerWorldEvents.LOAD.addPhaseOrdering(Event.DEFAULT_PHASE, runAfterFabricAPIPhase);
        ServerWorldEvents.LOAD.register(runAfterFabricAPIPhase, (minecraftServer, serverLevel) -> {
            HashMap tempMap;
            class_5311 worldStructureSettings;
            block4: {
                Set possibleBiomes;
                class_2378 biomeRegistry;
                block3: {
                    worldStructureSettings = serverLevel.method_14178().method_12129().method_12109();
                    biomeRegistry = serverLevel.method_30349().method_30530(class_2378.field_25114);
                    possibleBiomes = serverLevel.method_14178().method_12129().method_12098().method_28443();
                    HashMap tempStructureToMultiMap = new HashMap();
                    ((StructureSettingsAccessor)worldStructureSettings).getConfiguredStructures().forEach((key, value) -> tempStructureToMultiMap.put((class_3195<?>)key, (Multimap<class_5312<?, ?>, class_5321<class_1959>>)HashMultimap.create((Multimap)value)));
                    BiomeInjection.addStructureToBiomes(tempStructureToMultiMap, (class_2378<class_1959>)biomeRegistry);
                    ImmutableMap.Builder immutableOuterMap = ImmutableMap.builder();
                    tempStructureToMultiMap.forEach((key, value) -> {
                        ImmutableMultimap.Builder immutableInnerMultiMap = ImmutableMultimap.builder();
                        immutableInnerMultiMap.putAll(value);
                        immutableOuterMap.put(key, (Object)immutableInnerMultiMap.build());
                    });
                    ((StructureSettingsAccessor)worldStructureSettings).setConfiguredStructures(immutableOuterMap.build());
                    tempMap = new HashMap(worldStructureSettings.method_28598());
                    if (!(serverLevel.method_14178().method_12129() instanceof class_2897) || !serverLevel.method_27983().equals(class_1937.field_25179)) break block3;
                    tempMap.keySet().removeAll(RSStructures.RS_STRUCTURES.keySet());
                    break block4;
                }
                for (Map.Entry<class_3195<?>, class_5314> structureFeatureEntry : RSStructures.RS_STRUCTURES.entrySet()) {
                    block6: {
                        block5: {
                            boolean isWorldBlacklisted = GeneralUtils.isBlacklistedForWorld((class_5425)serverLevel, class_2378.field_16644.method_10221(structureFeatureEntry.getKey()));
                            Set validBiomesForStructure = serverLevel.method_14178().method_12129().method_12109().method_38424(structureFeatureEntry.getKey()).values().stream().map(arg_0 -> ((class_2378)biomeRegistry).method_29107(arg_0)).collect(Collectors.toSet());
                            if (isWorldBlacklisted) break block5;
                            if (!validBiomesForStructure.stream().noneMatch(possibleBiomes::contains)) break block6;
                        }
                        tempMap.remove(structureFeatureEntry.getKey());
                        continue;
                    }
                    tempMap.putIfAbsent(structureFeatureEntry.getKey(), structureFeatureEntry.getValue());
                }
            }
            ((StructureSettingsAccessor)worldStructureSettings).repurposedstructures_setStructureConfig(tempMap);
        });
    }

    public static void setupBiomeModifications() {
        Dungeons.addDungeons();
        Wells.addWells();
    }
}

