/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.mixin.fabric.client;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.impl.ScreenAccessImpl;
import dev.architectury.impl.TooltipEventColorContextImpl;
import dev.architectury.impl.TooltipEventPositionContextImpl;
import dev.architectury.impl.fabric.ScreenInputDelegate;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_437.class})
public abstract class MixinScreen
implements ScreenInputDelegate {
    @Unique
    private static ThreadLocal<TooltipEventPositionContextImpl> tooltipPositionContext = ThreadLocal.withInitial(TooltipEventPositionContextImpl::new);
    @Unique
    private static ThreadLocal<TooltipEventColorContextImpl> tooltipColorContext = ThreadLocal.withInitial(TooltipEventColorContextImpl::new);
    @Unique
    private ScreenAccessImpl access;
    @Unique
    private class_437 inputDelegate;

    @Shadow
    public abstract List<? extends class_364> method_25396();

    @Unique
    private ScreenAccess getAccess() {
        if (this.access == null) {
            this.access = new ScreenAccessImpl((class_437)this);
            return this.access;
        }
        this.access.setScreen((class_437)this);
        return this.access;
    }

    @Override
    public class_437 architectury_delegateInputs() {
        if (this.inputDelegate == null) {
            this.inputDelegate = new ScreenInputDelegate.DelegateScreen((class_437)this);
        }
        return this.inputDelegate;
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;clearWidgets()V", ordinal=0)}, cancellable=true)
    private void preInit(class_310 minecraft, int i, int j, CallbackInfo ci) {
        if (ClientGuiEvent.INIT_PRE.invoker().init((class_437)this, this.getAccess()).isFalse()) {
            ci.cancel();
        }
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="RETURN")})
    private void postInit(class_310 minecraft, int i, int j, CallbackInfo ci) {
        ClientGuiEvent.INIT_POST.invoker().init((class_437)this, this.getAccess());
    }

    @ModifyVariable(method={"sendMessage(Ljava/lang/String;Z)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private String modifyMessage(String message) {
        CompoundEventResult<String> process = ClientChatEvent.PROCESS.invoker().process(message);
        if (process.isPresent()) {
            if (process.isFalse()) {
                return "";
            }
            if (process.object() != null) {
                return process.object();
            }
        }
        return message;
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTooltip(class_4587 poseStack, List<? extends class_5684> list, int x, int y, CallbackInfo ci) {
        if (!list.isEmpty()) {
            TooltipEventColorContextImpl colorContext = tooltipColorContext.get();
            colorContext.reset();
            TooltipEventPositionContextImpl positionContext = tooltipPositionContext.get();
            positionContext.reset(x, y);
            if (ClientTooltipEvent.RENDER_PRE.invoker().renderTooltip(poseStack, list, x, y).isFalse()) {
                ci.cancel();
            } else {
                ClientTooltipEvent.RENDER_MODIFY_COLOR.invoker().renderTooltip(poseStack, x, y, colorContext);
                ClientTooltipEvent.RENDER_MODIFY_POSITION.invoker().renderTooltip(poseStack, positionContext);
            }
        }
    }

    @ModifyVariable(method={"renderTooltipInternal"}, at=@At(value="HEAD"), ordinal=0)
    private int modifyTooltipX(int original) {
        return tooltipPositionContext.get().getTooltipX();
    }

    @ModifyVariable(method={"renderTooltipInternal"}, at=@At(value="HEAD"), ordinal=1)
    private int modifyTooltipY(int original) {
        return tooltipPositionContext.get().getTooltipY();
    }

    @ModifyConstant(method={"renderTooltipInternal"}, constant={@Constant(intValue=-267386864)})
    private int modifyTooltipBackgroundColor(int original) {
        return tooltipColorContext.get().getBackgroundColor();
    }

    @ModifyConstant(method={"renderTooltipInternal"}, constant={@Constant(intValue=0x505000FF)})
    private int modifyTooltipOutlineGradientTopColor(int original) {
        return tooltipColorContext.get().getOutlineGradientTopColor();
    }

    @ModifyConstant(method={"renderTooltipInternal"}, constant={@Constant(intValue=1344798847)})
    private int modifyTooltipOutlineGradientBottomColor(int original) {
        return tooltipColorContext.get().getOutlineGradientBottomColor();
    }
}

