/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.EmptyPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.util.MergedItemStack;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_918;

public abstract class BasePreviewRenderer
implements PreviewRenderer {
    protected PreviewType previewType;
    protected int compactMaxRowSize;
    protected int maxRowSize = 9;
    protected class_2960 textureOverride;
    protected PreviewProvider provider;
    protected List<MergedItemStack> items = new ArrayList<MergedItemStack>();
    protected PreviewContext previewContext;

    protected BasePreviewRenderer() {
        this.previewType = PreviewType.FULL;
        this.setPreview(PreviewContext.of(new class_1799((class_1935)class_1802.field_8162)), EmptyPreviewProvider.INSTANCE);
    }

    protected int getMaxRowSize() {
        return this.previewType == PreviewType.COMPACT ? this.compactMaxRowSize : this.maxRowSize;
    }

    protected int getInvSize() {
        return this.previewType == PreviewType.COMPACT ? Math.max(1, this.items.size()) : this.provider.getInventoryMaxSize(this.previewContext);
    }

    @Override
    public void setPreviewType(PreviewType type) {
        this.previewType = type;
    }

    @Override
    public void setPreview(PreviewContext context, PreviewProvider provider) {
        List<class_1799> inventory = provider.getInventory(context);
        int rowSize = provider.getMaxRowSize(context);
        this.compactMaxRowSize = ShulkerBoxTooltip.config.preview.defaultMaxRowSize;
        if (this.compactMaxRowSize <= 0) {
            this.compactMaxRowSize = 9;
        }
        if (rowSize <= 0) {
            rowSize = this.compactMaxRowSize;
        }
        this.maxRowSize = rowSize <= 0 ? 9 : rowSize;
        this.textureOverride = provider.getTextureOverride(context);
        this.provider = provider;
        this.items = MergedItemStack.mergeInventory(inventory, provider.getInventoryMaxSize(context), ShulkerBoxTooltip.config.preview.compactPreviewNbtBehavior != Configuration.CompactPreviewNbtBehavior.SEPARATE);
        this.previewContext = context;
    }

    protected void renderMergedStack(class_1799 stack, class_918 itemRenderer, class_327 textRenderer, int x, int y) {
        itemRenderer.method_4023(stack, x, y);
        if (!ShulkerBoxTooltip.config.preview.shortItemCounts || stack.method_7947() == 1) {
            itemRenderer.method_4025(textRenderer, stack, x, y);
        } else {
            itemRenderer.method_4022(textRenderer, stack, x, y, ShulkerBoxTooltipUtil.abrieviateInteger(stack.method_7947()));
        }
    }

    protected void renderSubStack(class_1799 stack, class_918 itemRenderer, class_327 textRenderer, int x, int y, int slot) {
        itemRenderer.method_32797(stack, x, y, slot);
        itemRenderer.method_4025(textRenderer, stack, x, y);
    }
}

