/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network;

import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.network.C2SPackets;
import com.misterpemodder.shulkerboxtooltip.impl.network.ProtocolVersion;
import com.misterpemodder.shulkerboxtooltip.impl.network.S2CPackets;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public final class ClientNetworking {
    @Nullable
    private static ProtocolVersion serverProtocolVersion;

    public static void init() {
        if (ShulkerBoxTooltip.config.preview.serverIntegration) {
            ClientPlayConnectionEvents.INIT.register((handler, client) -> S2CPackets.registerReceivers());
        }
        ClientPlayConnectionEvents.JOIN.register(ClientNetworking::onJoinServer);
        C2SPlayChannelEvents.REGISTER.register(ClientNetworking::onChannelRegister);
    }

    private static void onJoinServer(class_634 handler, PacketSender sender, class_310 client) {
        client.execute(ShulkerBoxTooltip::initPreviewItemsMap);
        ShulkerBoxTooltip.config = ConfigurationHandler.copyOf(ShulkerBoxTooltip.savedConfig);
        serverProtocolVersion = null;
        if (!class_310.method_1551().method_1496()) {
            ConfigurationHandler.reinitClientSideSyncedValues(ShulkerBoxTooltip.config);
        }
    }

    private static void onChannelRegister(class_634 handler, PacketSender sender, class_310 client, List<class_2960> channels) {
        if (ShulkerBoxTooltip.config.preview.serverIntegration && serverProtocolVersion == null && channels.contains(C2SPackets.HANDSHAKE_TO_SERVER)) {
            C2SPackets.startHandshake(sender);
        }
    }

    public static void onHandshakeFinished(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        ProtocolVersion serverVersion = ProtocolVersion.readFromPacketBuf(buf);
        ShulkerBoxTooltip.LOGGER.info("[" + ShulkerBoxTooltip.MOD_NAME + "] Handshake succeeded");
        if (serverVersion != null) {
            if (serverVersion.major == ProtocolVersion.CURRENT.major) {
                ShulkerBoxTooltip.LOGGER.info("[" + ShulkerBoxTooltip.MOD_NAME + "] Server protocol version: " + serverVersion);
                serverProtocolVersion = serverVersion;
                try {
                    ConfigurationHandler.readFromPacketBuf(ShulkerBoxTooltip.config, buf);
                }
                catch (RuntimeException e) {
                    ShulkerBoxTooltip.LOGGER.error("failed to read server configuration", (Throwable)e);
                }
                ClientPlayNetworking.unregisterReceiver((class_2960)S2CPackets.HANDSHAKE_TO_CLIENT);
                return;
            }
            ShulkerBoxTooltip.LOGGER.error("[" + ShulkerBoxTooltip.MOD_NAME + "] Incompatible server protocol version, expected " + ProtocolVersion.CURRENT.major + ", got " + serverVersion.major);
        } else {
            ShulkerBoxTooltip.LOGGER.error("[" + ShulkerBoxTooltip.MOD_NAME + "] Could not read server protocol version");
        }
        S2CPackets.unregisterReceivers();
    }

    public static void onEnderChestUpdate(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        try {
            class_2487 compound = buf.method_10798();
            if (compound == null || !compound.method_10573("inv", 9)) {
                return;
            }
            class_2499 tags = compound.method_10554("inv", 10);
            client.execute(() -> client.field_1724.method_7274().method_7659(tags));
        }
        catch (RuntimeException e) {
            ShulkerBoxTooltip.LOGGER.error("could not read ender chest update packet from server", (Throwable)e);
        }
    }

    public static ProtocolVersion serverProtocolVersion() {
        return serverProtocolVersion;
    }
}

