/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.provider;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class BlockEntityPreviewProvider
implements PreviewProvider {
    protected final int maxInvSize;
    protected final boolean canUseLootTables;
    protected final int maxRowSize;

    public BlockEntityPreviewProvider(int maxInvSize, boolean canUseLootTables) {
        this.maxInvSize = maxInvSize;
        this.canUseLootTables = canUseLootTables;
        this.maxRowSize = 9;
    }

    public BlockEntityPreviewProvider(int maxInvSize, boolean canUseLootTables, int maxRowSize) {
        this.maxInvSize = maxInvSize;
        this.canUseLootTables = canUseLootTables;
        this.maxRowSize = maxRowSize <= 0 ? 9 : maxRowSize;
    }

    @Override
    public boolean shouldDisplay(PreviewContext context) {
        class_2487 blockEntityTag = context.getStack().method_7941("BlockEntityTag");
        if (blockEntityTag == null || this.canUseLootTables && blockEntityTag.method_10573("LootTable", 8) || !blockEntityTag.method_10573("Items", 9)) {
            return false;
        }
        return !blockEntityTag.method_10554("Items", 10).isEmpty();
    }

    @Override
    public boolean showTooltipHints(PreviewContext context) {
        return context.getStack().method_7941("BlockEntityTag") != null;
    }

    @Override
    public List<class_1799> getInventory(PreviewContext context) {
        class_2499 itemList;
        int invMaxSize = this.getInventoryMaxSize(context);
        class_2371 inv = class_2371.method_10213((int)invMaxSize, (Object)class_1799.field_8037);
        class_2487 blockEntityTag = context.getStack().method_7941("BlockEntityTag");
        if (blockEntityTag != null && blockEntityTag.method_10573("Items", 9) && (itemList = blockEntityTag.method_10554("Items", 10)) != null) {
            int len = itemList.size();
            for (int i = 0; i < len; ++i) {
                byte slot;
                class_2487 itemTag = itemList.method_10602(i);
                class_1799 s = class_1799.method_7915((class_2487)itemTag);
                if (!itemTag.method_10573("Slot", 1) || (slot = itemTag.method_10571("Slot")) >= invMaxSize) continue;
                inv.set(slot, s);
            }
        }
        return inv;
    }

    @Override
    public int getInventoryMaxSize(PreviewContext context) {
        return this.maxInvSize;
    }

    @Override
    public List<class_2561> addTooltip(PreviewContext context) {
        class_2487 blockEntityTag;
        class_1799 stack = context.getStack();
        class_2487 compound = stack.method_7969();
        class_2583 style = class_2583.field_24360.method_10977(class_124.field_1080);
        if (this.canUseLootTables && compound != null && compound.method_10573("BlockEntityTag", 10) && (blockEntityTag = compound.method_10562("BlockEntityTag")) != null && blockEntityTag.method_10573("LootTable", 8)) {
            return switch (ShulkerBoxTooltip.config.tooltip.lootTableInfoType) {
                case Configuration.LootTableInfoType.HIDE -> Collections.emptyList();
                case Configuration.LootTableInfoType.SIMPLE -> Collections.singletonList(new class_2588("shulkerboxtooltip.hint.lootTable").method_10862(style));
                default -> Arrays.asList(new class_2588("shulkerboxtooltip.hint.lootTable.advanced").method_10852((class_2561)new class_2585(": ")), new class_2585(" " + blockEntityTag.method_10558("LootTable")).method_10862(style));
            };
        }
        if (ShulkerBoxTooltipApi.isFullPreviewKeyPressed()) {
            return Collections.emptyList();
        }
        return BlockEntityPreviewProvider.getItemListTooltip(new ArrayList<class_2561>(), this.getInventory(context), style);
    }

    public static List<class_2561> getItemCountTooltip(List<class_2561> tooltip, @Nullable List<class_1799> items) {
        return BlockEntityPreviewProvider.getItemListTooltip(tooltip, items, class_2583.field_24360.method_10977(class_124.field_1080));
    }

    public static List<class_2561> getItemListTooltip(List<class_2561> tooltip, @Nullable List<class_1799> items, class_2583 style) {
        if (items != null) {
            int item_count = 0;
            for (class_1799 s : items) {
                if (s.method_7909() == class_1802.field_8162) continue;
                ++item_count;
            }
            if (item_count > 0) {
                tooltip.add((class_2561)new class_2588("container.shulkerbox.contains", new Object[]{item_count}).method_10862(style));
                return tooltip;
            }
        }
        tooltip.add((class_2561)new class_2588("container.shulkerbox.empty").method_10862(style));
        return tooltip;
    }

    @Override
    public int getMaxRowSize(PreviewContext context) {
        return this.maxRowSize;
    }
}

