/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3675;

public interface ShulkerBoxTooltipApi {
    @Nullable
    public static PreviewProvider getPreviewProviderForStack(class_1799 stack) {
        return PreviewProviderRegistry.getInstance().get(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isPreviewAvailable(PreviewContext context) {
        if (ShulkerBoxTooltip.config.preview.enable) {
            PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(context.getStack());
            return provider != null && provider.shouldDisplay(context) && ShulkerBoxTooltipApi.getCurrentPreviewType(provider.isFullPreviewAvailable(context)) != PreviewType.NO_PREVIEW;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        boolean shouldDisplay = ShulkerBoxTooltipClient.shouldDisplayPreview();
        if (shouldDisplay && !hasFullPreviewMode) {
            return PreviewType.COMPACT;
        }
        if (ShulkerBoxTooltip.config.preview.swapModes) {
            if (shouldDisplay) {
                return ShulkerBoxTooltipApi.isFullPreviewKeyPressed() ? PreviewType.COMPACT : PreviewType.FULL;
            }
        } else if (shouldDisplay) {
            return ShulkerBoxTooltipApi.isFullPreviewKeyPressed() ? PreviewType.FULL : PreviewType.COMPACT;
        }
        return PreviewType.NO_PREVIEW;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isPreviewKeyPressed() {
        Key key = ShulkerBoxTooltip.config.controls.previewKey;
        if (key == null || key.equals(Key.UNKNOWN_KEY) || key.get().equals((Object)class_3675.field_16237)) {
            return false;
        }
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.get().method_1444());
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isFullPreviewKeyPressed() {
        Key key = ShulkerBoxTooltip.config.controls.fullPreviewKey;
        if (key == null || key.equals(Key.UNKNOWN_KEY) || key.get().equals((Object)class_3675.field_16237)) {
            return false;
        }
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.get().method_1444());
    }

    public static boolean hasModAvailable(class_3222 player) {
        return ServerNetworking.hasModAvailable(player);
    }

    public void registerProviders(PreviewProviderRegistry var1);
}

