/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures;

import com.google.common.collect.ImmutableList;
import draylar.omegaconfig.OmegaConfig;
import io.github.frqnny.mostructures.ConfiguredFeatures;
import io.github.frqnny.mostructures.config.MoStructuresConfig;
import io.github.frqnny.mostructures.feature.VillagerEntityFeature;
import io.github.frqnny.mostructures.processor.AirStructureProcessor;
import io.github.frqnny.mostructures.processor.DataBlockStructureProcessor;
import io.github.frqnny.mostructures.processor.RemoveWaterloggedProcessor;
import io.github.frqnny.mostructures.processor.SimpleCobblestoneProcessor;
import io.github.frqnny.mostructures.processor.SimpleStoneStructureProcessor;
import io.github.frqnny.mostructures.structure.AirBalloonStructure;
import io.github.frqnny.mostructures.structure.MoaiStructure;
import io.github.frqnny.mostructures.structure.ModStructure;
import io.github.frqnny.mostructures.structure.VolcanicVentStructure;
import io.github.frqnny.mostructures.util.RegUtils;
import io.github.frqnny.mostructures.util.StrucUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3491;
import net.minecraft.class_3773;
import net.minecraft.class_3812;
import net.minecraft.class_3828;
import net.minecraft.class_5321;
import net.minecraft.class_5497;

public class MoStructures
implements ModInitializer {
    public static final String MODID = "mostructures";
    public static final MoStructuresConfig config = (MoStructuresConfig)OmegaConfig.register(MoStructuresConfig.class);
    public static final class_3031<class_3111> VILLAGER_SPAWN = new VillagerEntityFeature();
    public static final class_3195<class_3812> BARN_HOUSE = new ModStructure();
    public static final class_3195<class_3812> BIG_PYRAMID = new ModStructure();
    public static final class_3195<class_3812> JUNGLE_PYRAMID = new ModStructure();
    public static final class_3195<class_3812> THE_CASTLE_IN_THE_SKY = new ModStructure(60);
    public static final class_3195<class_3812> VILLAGER_TOWER = new ModStructure();
    public static final class_3195<class_3812> VILLAGER_MARKET = new ModStructure();
    public static final class_3195<class_3812> VILLAGER_BAZAAR = new ModStructure();
    public static final class_3195<class_3812> PILLAGER_FACTORY = new ModStructure();
    public static final class_3195<class_3812> ABANDONED_CHURCH = new ModStructure();
    public static final class_3195<class_3812> ICE_TOWER = new ModStructure();
    public static final class_3195<class_3812> TAVERN = new ModStructure();
    public static final class_3195<class_3812> KILLER_BUNNY_CASTLE = new ModStructure();
    public static final class_3195<class_3812> PIRATE_SHIP = new ModStructure(58, false, false);
    public static final class_3195<class_3812> LIGHTHOUSE = new ModStructure(65, false, false);
    public static final class_3195<class_3111> VOLCANIC_VENT = new VolcanicVentStructure();
    public static final class_3195<class_3812> MOAI = new MoaiStructure(-3);
    public static final class_3195<class_3812> AIR_BALLOON = new AirBalloonStructure();
    public static final class_3773 VOLCANIC_VENT_TYPE = (class_3773)class_2378.method_10230((class_2378)class_2378.field_16645, (class_2960)MoStructures.id("volcanic_vent"), VolcanicVentStructure.Piece::new);
    public static final class_3828<SimpleStoneStructureProcessor> SIMPLE_STONE = class_3828.method_16822((String)"jungle_rot_processor", SimpleStoneStructureProcessor.CODEC);
    public static final class_3828<SimpleCobblestoneProcessor> SIMPLE_COBBLESTONE = class_3828.method_16822((String)"simple_cobblestone", SimpleCobblestoneProcessor.CODEC);
    public static final class_3828<DataBlockStructureProcessor> DATA_BLOCK_STRUCTURE_PROCESSOR = class_3828.method_16822((String)"data_block_structure_processor", DataBlockStructureProcessor.CODEC);
    public static final class_3828<AirStructureProcessor> AIR_STRUCTURE_PROCESSOR = class_3828.method_16822((String)"air_structure_processor", AirStructureProcessor.CODEC);
    public static final class_3828<RemoveWaterloggedProcessor> REMOVE_WATERLOGGED = class_3828.method_16822((String)"remove_waterlog_processor", RemoveWaterloggedProcessor.CODEC);
    public static final class_5497 JUNGLE_ROT_LIST = RegUtils.registerStructureProcessorList("jungle_rot", (ImmutableList<class_3491>)ImmutableList.of((Object)((Object)new SimpleStoneStructureProcessor(0.15f))));
    public static final class_5497 ICE_TOWER_LIST = RegUtils.registerStructureProcessorList("ice_tower_rot", (ImmutableList<class_3491>)ImmutableList.of((Object)((Object)new SimpleStoneStructureProcessor(0.0f))));
    public static final class_5497 VILLAGER_TOWER_LIST = RegUtils.registerStructureProcessorList("villager_tower_rot", (ImmutableList<class_3491>)ImmutableList.of((Object)((Object)new SimpleCobblestoneProcessor(0.15f))));
    public static final class_5497 PIRATE_SHIP_LIST = RegUtils.registerStructureProcessorList("simple_air_keep_list", (ImmutableList<class_3491>)ImmutableList.of((Object)((Object)new AirStructureProcessor()), (Object)((Object)new RemoveWaterloggedProcessor())));

    public static class_2960 id(String name) {
        return new class_2960(MODID, name);
    }

    private static void registerStructures() {
        RegUtils.registerStructure(StrucUtils.BARN_HOUSE, BARN_HOUSE, ConfiguredFeatures.BARN_HOUSE);
        RegUtils.registerStructure(StrucUtils.BIG_PYRAMID, BIG_PYRAMID, ConfiguredFeatures.BIG_PYRAMID);
        RegUtils.registerStructure(StrucUtils.JUNGLE_PYRAMID, JUNGLE_PYRAMID, ConfiguredFeatures.JUNGLE_PYRAMID);
        RegUtils.registerStructure(StrucUtils.VILLAGER_TOWER, VILLAGER_TOWER, ConfiguredFeatures.VILLAGER_TOWER);
        RegUtils.registerStructure(StrucUtils.ABANDONED_CHURCH, ABANDONED_CHURCH, ConfiguredFeatures.PLAINS_ABANDONED_CHURCH);
        RegUtils.registerStructure(StrucUtils.VILLAGER_MARKET, VILLAGER_MARKET, ConfiguredFeatures.VILLAGER_MARKET);
        RegUtils.registerStructure(StrucUtils.VILLAGER_BAZAAR, VILLAGER_BAZAAR, ConfiguredFeatures.VILLAGER_BAZAAR);
        RegUtils.registerStructure(StrucUtils.PILLAGER_FACTORY, PILLAGER_FACTORY, ConfiguredFeatures.PILLAGER_FACTORY);
        RegUtils.registerStructure(StrucUtils.ICE_TOWER, ICE_TOWER, ConfiguredFeatures.ICE_TOWER);
        RegUtils.registerStructure(StrucUtils.TAVERN, TAVERN, ConfiguredFeatures.TAVERN);
        RegUtils.registerStructure(StrucUtils.KILLER_BUNNY_CASTLE, KILLER_BUNNY_CASTLE, ConfiguredFeatures.KILLER_BUNNY_CASTLE);
        RegUtils.registerStructure(StrucUtils.THE_CASTLE_IN_THE_SKY, THE_CASTLE_IN_THE_SKY, ConfiguredFeatures.THE_CASTLE_IN_THE_SKY, false);
        RegUtils.registerStructure(StrucUtils.PIRATE_SHIP, PIRATE_SHIP, ConfiguredFeatures.PIRATE_SHIP, false);
        RegUtils.registerStructure(StrucUtils.LIGHTHOUSE, LIGHTHOUSE, ConfiguredFeatures.LIGHTHOUSE, false);
        RegUtils.registerStructure(StrucUtils.VOLCANIC_VENT, VOLCANIC_VENT, ConfiguredFeatures.VOLCANIC_VENT, false);
        RegUtils.registerStructure(StrucUtils.MOAI, MOAI, ConfiguredFeatures.MOAI, false);
        RegUtils.registerStructure(StrucUtils.AIR_BALLOON, AIR_BALLOON, ConfiguredFeatures.AIR_BALLOON, false);
    }

    private static void registerFeatures() {
        class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)VillagerEntityFeature.ID, VILLAGER_SPAWN);
    }

    private static void putStructures() {
        RegUtils.addToBiome(StrucUtils.BARN_HOUSE, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355, class_1959.class_1961.field_9356}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.BARN_HOUSE))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.BARN_HOUSE));
        RegUtils.addToBiome(StrucUtils.BIG_PYRAMID, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9368}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.BIG_PYRAMID))).and(RegUtils.getNoHillsPredicate()).and(BiomeSelectors.foundInOverworld()).and(context -> !context.getBiomeKey().method_29177().method_12832().contains("lakes")), context -> RegUtils.addStructure(context, ConfiguredFeatures.BIG_PYRAMID));
        RegUtils.addToBiome(StrucUtils.JUNGLE_PYRAMID, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9358}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.JUNGLE_PYRAMID))).and(RegUtils.getNoHillsPredicate()).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.JUNGLE_PYRAMID));
        RegUtils.addToBiome(StrucUtils.THE_CASTLE_IN_THE_SKY, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9363}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.THE_CASTLE_IN_THE_SKY))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.THE_CASTLE_IN_THE_SKY));
        RegUtils.addToBiome(StrucUtils.VILLAGER_TOWER, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355, class_1959.class_1961.field_9370}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.VILLAGER_TOWER))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.VILLAGER_TOWER));
        RegUtils.addToBiome(StrucUtils.VILLAGER_TOWER, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9356}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.VILLAGER_TOWER))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.SAVANNA_VILLAGER_TOWER));
        RegUtils.addToBiome(StrucUtils.VILLAGER_MARKET, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355, class_1959.class_1961.field_9356, class_1959.class_1961.field_9370}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.VILLAGER_MARKET))).and(RegUtils.getNoHillsPredicate()).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.VILLAGER_MARKET));
        RegUtils.addToBiome(StrucUtils.PILLAGER_FACTORY, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355, class_1959.class_1961.field_9361, class_1959.class_1961.field_9362}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.PILLAGER_FACTORY))).and(RegUtils.getNoHillsPredicate()).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.PILLAGER_FACTORY));
        RegUtils.addToBiome(StrucUtils.PIRATE_SHIP, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9367}).and(context -> {
            String string = context.getBiomeKey().method_29177().toString();
            return string.contains("deep") && !string.contains("frozen");
        }).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.PIRATE_SHIP))), context -> RegUtils.addStructure(context, ConfiguredFeatures.PIRATE_SHIP));
        RegUtils.addToBiome(StrucUtils.ABANDONED_CHURCH, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.ABANDONED_CHURCH))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.PLAINS_ABANDONED_CHURCH));
        RegUtils.addToBiome(StrucUtils.ABANDONED_CHURCH, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9368}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.ABANDONED_CHURCH))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.DESERT_ABANDONED_CHURCH));
        RegUtils.addToBiome(StrucUtils.ABANDONED_CHURCH, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9356}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.ABANDONED_CHURCH))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.SAVANNA_ABANDONED_CHURCH));
        RegUtils.addToBiome(StrucUtils.ABANDONED_CHURCH, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9361}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.ABANDONED_CHURCH))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.TAIGA_ABANDONED_CHURCH));
        RegUtils.addToBiome(StrucUtils.ABANDONED_CHURCH, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9362}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.ABANDONED_CHURCH))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.SNOWY_ABANDONED_CHURCH));
        RegUtils.addToBiome(StrucUtils.ICE_TOWER, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9362}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.ICE_TOWER))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.ICE_TOWER));
        RegUtils.addToBiome(StrucUtils.TAVERN, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355, class_1959.class_1961.field_9370}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.TAVERN))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.TAVERN));
        RegUtils.addToBiome(StrucUtils.KILLER_BUNNY_CASTLE, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9355, class_1959.class_1961.field_9370, class_1959.class_1961.field_9356}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.KILLER_BUNNY_CASTLE))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.KILLER_BUNNY_CASTLE));
        RegUtils.addToBiome(StrucUtils.LIGHTHOUSE, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9363}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.LIGHTHOUSE))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.LIGHTHOUSE));
        RegUtils.addToBiome(StrucUtils.VOLCANIC_VENT, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9367}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.VOLCANIC_VENT))).and(BiomeSelectors.excludeByKey((class_5321[])new class_5321[]{class_1972.field_9435, class_1972.field_9418})).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.VOLCANIC_VENT));
        RegUtils.addToBiome(StrucUtils.MOAI, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9363}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.MOAI))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.MOAI));
        RegUtils.addToBiome(StrucUtils.AIR_BALLOON, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9363}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.AIR_BALLOON))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.AIR_BALLOON));
        RegUtils.addToBiome(StrucUtils.VILLAGER_BAZAAR, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9368}).and(RegUtils.booleanToPredicate(config.activated(StrucUtils.VILLAGER_BAZAAR))).and(BiomeSelectors.foundInOverworld()), context -> RegUtils.addStructure(context, ConfiguredFeatures.VILLAGER_BAZAAR));
    }

    public void onInitialize() {
        MoStructures.registerStructures();
        MoStructures.registerFeatures();
        ConfiguredFeatures.registerConfiguredFeatures();
        MoStructures.putStructures();
    }
}

