/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.colors;

import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;

public class SeasonFoliageColors {
    private static int[] springColorMap = new int[65536];
    private static int[] summerColorMap = new int[65536];
    private static int[] fallColorMap = new int[65536];
    private static int[] winterColorMap = new int[65536];

    public static void setColorMap(Season season, int[] pixels) {
        switch (season) {
            case SPRING: {
                springColorMap = pixels;
                break;
            }
            case SUMMER: {
                summerColorMap = pixels;
                break;
            }
            case FALL: {
                fallColorMap = pixels;
                break;
            }
            case WINTER: {
                winterColorMap = pixels;
            }
        }
    }

    public static int getColor(Season season, double temperature, double humidity) {
        int i = (int)((1.0 - temperature) * 255.0);
        int j = (int)((1.0 - (humidity *= temperature)) * 255.0);
        switch (season) {
            case SPRING: {
                return springColorMap[j << 8 | i];
            }
            case SUMMER: {
                return summerColorMap[j << 8 | i];
            }
            case FALL: {
                return fallColorMap[j << 8 | i];
            }
            case WINTER: {
                return winterColorMap[j << 8 | i];
            }
        }
        return springColorMap[j << 8 | i];
    }

    public static int getSpruceColor(Season season) {
        return FabricSeasons.CONFIG.getMinecraftSpruceFoliage().getColor(season);
    }

    public static int getBirchColor(Season season) {
        return FabricSeasons.CONFIG.getMinecraftBirchFoliage().getColor(season);
    }

    public static int getDefaultColor(Season season) {
        return FabricSeasons.CONFIG.getMinecraftDefaultFoliage().getColor(season);
    }
}

