/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import io.github.lucaargolo.seasons.block.GreenhouseGlassBlock;
import io.github.lucaargolo.seasons.block.SeasonDetectorBlock;
import io.github.lucaargolo.seasons.blockentities.GreenhouseGlassBlockEntity;
import io.github.lucaargolo.seasons.blockentities.SeasonDetectorBlockEntity;
import io.github.lucaargolo.seasons.commands.SeasonCommand;
import io.github.lucaargolo.seasons.item.SeasonCalendarItem;
import io.github.lucaargolo.seasons.mixin.WeatherAccessor;
import io.github.lucaargolo.seasons.utils.GreenhouseCache;
import io.github.lucaargolo.seasons.utils.ModConfig;
import io.github.lucaargolo.seasons.utils.ModIdentifier;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasons.utils.WeatherCache;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2378;
import net.minecraft.class_2473;
import net.minecraft.class_2513;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricSeasons
implements ModInitializer {
    public static final String MOD_ID = "seasons";
    public static final Logger LOGGER = LogManager.getLogger((String)"Fabric Seasons");
    public static ModConfig CONFIG;
    public static final JsonParser JSON_PARSER;
    public static final Gson GSON;
    public static class_2248 ORIGINAL_ICE;
    public static class_2248 ORIGINAL_SNOW;
    public static HashMap<class_1792, class_2248> SEEDS_MAP;
    public static class_2591<SeasonDetectorBlockEntity> SEASON_DETECTOR_TYPE;
    public static class_2591<GreenhouseGlassBlockEntity> GREENHOUSE_GLASS_TYPE;
    public static class_2960 ASK_FOR_CONFIG;
    public static class_2960 ANSWER_CONFIG;

    public void onInitialize() {
        block10: {
            Path configPath = FabricLoader.getInstance().getConfigDir();
            File configFile = new File(configPath + File.separator + "seasons.json");
            LOGGER.info("Trying to read config file...");
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("No config file found, creating a new one...");
                    String json = GSON.toJson(JSON_PARSER.parse(GSON.toJson((Object)new ModConfig())));
                    try (PrintWriter out = new PrintWriter(configFile);){
                        out.println(json);
                    }
                    CONFIG = new ModConfig();
                    LOGGER.info("Successfully created default config file.");
                    break block10;
                }
                LOGGER.info("A config file was found, loading it..");
                CONFIG = (ModConfig)GSON.fromJson(new String(Files.readAllBytes(configFile.toPath())), ModConfig.class);
                if (CONFIG == null) {
                    throw new NullPointerException("The config file was empty.");
                }
                LOGGER.info("Successfully loaded config file.");
            }
            catch (Exception exception) {
                LOGGER.error("There was an error creating/loading the config file!", (Throwable)exception);
                CONFIG = new ModConfig();
                LOGGER.warn("Defaulting to original config.");
            }
        }
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> SeasonCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SEEDS_MAP.clear();
            class_2378.field_11142.forEach(item -> {
                class_2248 block;
                if (item instanceof class_1747 && ((block = ((class_1747)item).method_7711()) instanceof class_2302 || block instanceof class_2513 || block instanceof class_2282 || block instanceof class_2473)) {
                    SEEDS_MAP.put((class_1792)item, ((class_1747)item).method_7711());
                }
            });
        });
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("season_calendar"), (Object)((Object)new SeasonCalendarItem(new class_1792.class_1793().method_7892(class_1761.field_7930))));
        SeasonDetectorBlock seasonDetector = (SeasonDetectorBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier("season_detector"), (Object)((Object)new SeasonDetectorBlock((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10429)))));
        SEASON_DETECTOR_TYPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new ModIdentifier("season_detector"), (Object)FabricBlockEntityTypeBuilder.create(seasonDetector::createBlockEntity, (class_2248[])new class_2248[]{seasonDetector}).build(null));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("season_detector"), (Object)new class_1747((class_2248)seasonDetector, new class_1792.class_1793().method_7892(class_1761.field_7914)));
        GreenhouseGlassBlock greenhouseGlass = (GreenhouseGlassBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new ModIdentifier("greenhouse_glass"), (Object)((Object)new GreenhouseGlassBlock((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10357)))));
        GREENHOUSE_GLASS_TYPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new ModIdentifier("greenhouse_glass"), (Object)FabricBlockEntityTypeBuilder.create(greenhouseGlass::createBlockEntity, (class_2248[])new class_2248[]{greenhouseGlass}).build(null));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new ModIdentifier("greenhouse_glass"), (Object)new class_1747((class_2248)greenhouseGlass, new class_1792.class_1793().method_7892(class_1761.field_7928)));
        ServerTickEvents.END_SERVER_TICK.register(GreenhouseCache::tick);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ASK_FOR_CONFIG, (server, player, handler, buf, responseSender) -> {
            String configJson = GSON.toJson(JSON_PARSER.parse(GSON.toJson((Object)CONFIG)));
            class_2540 configBuf = PacketByteBufs.create();
            configBuf.method_10814(configJson);
            ServerPlayNetworking.send((class_3222)player, (class_2960)ANSWER_CONFIG, (class_2540)configBuf);
        });
    }

    public static Season getCurrentSeason(class_1937 world) {
        class_5321 dimension = world.method_27983();
        if (CONFIG.isValidInDimension((class_5321<class_1937>)dimension)) {
            if (CONFIG.isSeasonLocked()) {
                return CONFIG.getLockedSeason();
            }
            if (CONFIG.isSeasonTiedWithSystemTime()) {
                return FabricSeasons.getCurrentSystemSeason();
            }
            int worldTime = Math.toIntExact(world.method_8532());
            int seasonTime = worldTime / CONFIG.getSeasonLength();
            return Season.values()[seasonTime % 4];
        }
        return Season.SPRING;
    }

    @Environment(value=EnvType.CLIENT)
    public static Season getCurrentSeason() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player != null && player.field_6002 != null) {
            return FabricSeasons.getCurrentSeason(player.field_6002);
        }
        return Season.SPRING;
    }

    private static Season getCurrentSystemSeason() {
        Season season;
        LocalDateTime date = LocalDateTime.now();
        int m = date.getMonthValue();
        int d = date.getDayOfMonth();
        if (CONFIG.isInNorthHemisphere()) {
            season = m == 1 || m == 2 || m == 3 ? Season.WINTER : (m == 4 || m == 5 || m == 6 ? Season.SPRING : (m == 7 || m == 8 || m == 9 ? Season.SUMMER : Season.FALL));
            if (m == 3 && d > 19) {
                season = Season.SPRING;
            } else if (m == 6 && d > 20) {
                season = Season.SUMMER;
            } else if (m == 9 && d > 21) {
                season = Season.FALL;
            } else if (m == 12 && d > 20) {
                season = Season.WINTER;
            }
        } else {
            season = m == 1 || m == 2 || m == 3 ? Season.SUMMER : (m == 4 || m == 5 || m == 6 ? Season.FALL : (m == 7 || m == 8 || m == 9 ? Season.WINTER : Season.SPRING));
            if (m == 3 && d > 19) {
                season = Season.FALL;
            } else if (m == 6 && d > 20) {
                season = Season.WINTER;
            } else if (m == 9 && d > 21) {
                season = Season.SPRING;
            } else if (m == 12 && d > 20) {
                season = Season.SUMMER;
            }
        }
        return season;
    }

    public static void injectBiomeTemperature(class_1959 biome, class_1937 world) {
        class_1959.class_5482 originalWeather;
        if (!CONFIG.doTemperatureChanges()) {
            return;
        }
        List<class_1959.class_1961> ignoredCategories = Arrays.asList(class_1959.class_1961.field_9371, class_1959.class_1961.field_9366, class_1959.class_1961.field_9360, class_1959.class_1961.field_9367);
        if (ignoredCategories.contains(biome.method_8688())) {
            return;
        }
        Season season = FabricSeasons.getCurrentSeason(world);
        class_2960 biomeIdentifier = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
        class_1959.class_5482 currentWeather = biome.field_26393;
        if (!WeatherCache.hasCache(biomeIdentifier)) {
            originalWeather = new class_1959.class_5482(currentWeather.field_26399, currentWeather.field_26400, currentWeather.field_26401, currentWeather.field_26402);
            WeatherCache.setCache(biomeIdentifier, originalWeather);
        } else {
            originalWeather = WeatherCache.getCache(biomeIdentifier);
        }
        if (originalWeather == null) {
            return;
        }
        float temp = originalWeather.field_26400;
        if (biome.method_8688() == class_1959.class_1961.field_9358 || biome.method_8688() == class_1959.class_1961.field_9364) {
            if (season == Season.WINTER) {
                ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                ((WeatherAccessor)currentWeather).setTemperature(temp - 0.1f);
            } else {
                ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                ((WeatherAccessor)currentWeather).setTemperature(temp);
            }
        } else if ((double)temp <= 0.1) {
            switch (season) {
                case SUMMER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(class_1959.class_1963.field_9382);
                    ((WeatherAccessor)currentWeather).setTemperature(temp + 0.3f);
                    break;
                }
                case WINTER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(class_1959.class_1963.field_9383);
                    ((WeatherAccessor)currentWeather).setTemperature(temp - 0.2f);
                    break;
                }
                default: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                    ((WeatherAccessor)currentWeather).setTemperature(temp);
                    break;
                }
            }
        } else if ((double)temp <= 0.3) {
            switch (season) {
                case SPRING: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(class_1959.class_1963.field_9382);
                    ((WeatherAccessor)currentWeather).setTemperature(temp);
                    break;
                }
                case SUMMER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(class_1959.class_1963.field_9382);
                    ((WeatherAccessor)currentWeather).setTemperature(temp + 0.2f);
                    break;
                }
                case WINTER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(class_1959.class_1963.field_9383);
                    ((WeatherAccessor)currentWeather).setTemperature(temp - 0.2f);
                    break;
                }
                default: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                    ((WeatherAccessor)currentWeather).setTemperature(temp);
                    break;
                }
            }
        } else if ((double)temp <= 0.95) {
            switch (season) {
                case SUMMER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                    ((WeatherAccessor)currentWeather).setTemperature(temp + 0.2f);
                    break;
                }
                case FALL: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                    ((WeatherAccessor)currentWeather).setTemperature(temp - 0.1f);
                    break;
                }
                case WINTER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(class_1959.class_1963.field_9383);
                    ((WeatherAccessor)currentWeather).setTemperature(temp - 0.7f);
                    break;
                }
                default: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                    ((WeatherAccessor)currentWeather).setTemperature(temp);
                    break;
                }
            }
        } else {
            switch (season) {
                case SUMMER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                    ((WeatherAccessor)currentWeather).setTemperature(temp + 0.2f);
                    break;
                }
                case WINTER: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(class_1959.class_1963.field_9382);
                    ((WeatherAccessor)currentWeather).setTemperature(temp - 0.2f);
                    break;
                }
                default: {
                    ((WeatherAccessor)currentWeather).setPrecipitation(originalWeather.field_26399);
                    ((WeatherAccessor)currentWeather).setTemperature(temp);
                }
            }
        }
    }

    static {
        JSON_PARSER = new JsonParser();
        GSON = new GsonBuilder().setPrettyPrinting().create();
        SEEDS_MAP = new HashMap();
        SEASON_DETECTOR_TYPE = null;
        GREENHOUSE_GLASS_TYPE = null;
        ASK_FOR_CONFIG = new class_2960(MOD_ID, "ask_for_config");
        ANSWER_CONFIG = new class_2960(MOD_ID, "anwer_config");
    }
}

