/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.api.fiber.v1.tree;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberQueryException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigLeaf;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConfigQuery<T extends ConfigNode> {
    private final List<String> path;
    private final Class<? super T> nodeType;
    @Nullable
    private final SerializableType<?> valueType;

    public static ConfigQuery<ConfigBranch> branch(String first, String ... more) {
        return new ConfigQuery<ConfigBranch>(ConfigBranch.class, null, first, more);
    }

    public static <V> ConfigQuery<ConfigLeaf<V>> leaf(SerializableType<V> propertyType, String first, String ... more) {
        return new ConfigQuery<ConfigLeaf<V>>(ConfigLeaf.class, propertyType, first, more);
    }

    private ConfigQuery(Class<? super T> nodeType, @Nullable SerializableType<?> valueType, String first, String[] path) {
        this.nodeType = nodeType;
        this.valueType = valueType;
        this.path = new ArrayList<String>();
        this.path.add(first);
        this.path.addAll(Arrays.asList(path));
    }

    public Optional<T> search(ConfigTree cfg) {
        try {
            return Optional.of(this.run(cfg));
        }
        catch (FiberQueryException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    public T run(ConfigTree cfg) throws FiberQueryException {
        List<String> path = this.path;
        ConfigTree branch = cfg;
        int lastIndex = path.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            branch = this.lookupChild(branch, path.get(i), ConfigBranch.class, null);
        }
        ConfigNode result = (ConfigNode)this.lookupChild(branch, path.get(lastIndex), this.nodeType, this.valueType);
        return (T)result;
    }

    private <N> N lookupChild(ConfigTree tree, String name, Class<N> nodeType, @Nullable SerializableType<?> valueType) throws FiberQueryException {
        ConfigNode node = tree.lookup(name);
        if (nodeType.isInstance(node) && (valueType == null || valueType.equals(((ConfigLeaf)node).getConfigType()))) {
            return nodeType.cast(node);
        }
        if (node != null) {
            throw new FiberQueryException.WrongType(tree, node, nodeType, valueType);
        }
        throw new FiberQueryException.MissingChild(name, tree);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.nodeType.getSimpleName());
        if (this.valueType != null) {
            sb.append('<').append(this.valueType).append('>');
        }
        return sb.append("@'").append(String.join((CharSequence)".", this.path)).append('\'').toString();
    }
}

