/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.util;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public class OceanBiomeHelper {
    public static boolean isColdOrFrozenOcean(class_5321<class_1959> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == class_1972.field_9467 || biome == class_1972.field_9470 || biome == class_1972.field_9418 || biome == class_1972.field_9435 || types.contains(BiomeTypes.COLD) && types.contains(BiomeTypes.OCEAN));
    }

    public static boolean isDeepOcean(class_5321<class_1959> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == class_1972.field_9418 || biome == class_1972.field_9470 || biome == class_1972.field_9439 || biome == class_1972.field_9446 || biome.method_29177().method_12832().contains("deep"));
    }

    public static boolean isFrozenOcean(class_5321<class_1959> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == class_1972.field_9418 || biome == class_1972.field_9435 || biome.method_29177().method_12832().contains("frozen"));
    }

    public static boolean isWarmOcean(class_5321<class_1959> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == class_1972.field_9408 || biome.method_29177().method_12832().contains("warm") && !biome.method_29177().method_12832().contains("lukewarm"));
    }

    public static boolean isLukewarmOcean(class_5321<class_1959> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == class_1972.field_9439 || biome == class_1972.field_9441 || biome.method_29177().method_12832().contains("lukewarm"));
    }

    public static class_5321<class_1959>[] subtropicalOcean() {
        return OceanBiomeHelper.removeIf(biome -> !OceanBiomeHelper.isWarmOcean((class_5321<class_1959>)biome) && !OceanBiomeHelper.isLukewarmOcean((class_5321<class_1959>)biome) || OceanBiomeHelper.isDeepOcean((class_5321<class_1959>)biome));
    }

    public static class_5321<class_1959>[] returnIf(Predicate<class_5321<class_1959>> filter) {
        HashSet<class_5321<class_1959>> oceans = new HashSet<class_5321<class_1959>>();
        for (class_5321<class_1959> b : BiomeTypes.getBiomes(BiomeTypes.OCEAN)) {
            if (!filter.test(b)) continue;
            oceans.add(b);
        }
        return oceans.toArray(new class_5321[0]);
    }

    public static class_5321<class_1959>[] removeIf(Predicate<class_5321<class_1959>> filter) {
        HashSet<class_5321<class_1959>> oceans = new HashSet<class_5321<class_1959>>(BiomeTypes.getBiomes(BiomeTypes.OCEAN));
        oceans.removeIf(filter);
        return oceans.toArray(new class_5321[0]);
    }

    public static class Wrapper {
        private final boolean coldOrFrozen;
        private final boolean deep;
        private final boolean frozen;
        private final boolean warm;
        private final boolean lukewarm;

        public Wrapper(class_5321<class_1959> biome) {
            this.coldOrFrozen = OceanBiomeHelper.isColdOrFrozenOcean(biome);
            this.deep = OceanBiomeHelper.isDeepOcean(biome);
            this.frozen = OceanBiomeHelper.isFrozenOcean(biome);
            this.warm = OceanBiomeHelper.isWarmOcean(biome);
            this.lukewarm = OceanBiomeHelper.isLukewarmOcean(biome);
        }

        public boolean isLukewarm() {
            return this.lukewarm;
        }

        public boolean isWarm() {
            return this.warm;
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public boolean isColdOrFrozen() {
            return this.coldOrFrozen;
        }
    }
}

