/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.ai.HybridPathNavigator;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IContainerEntity;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import dev.itsmeow.betteranimalsplus.init.ModSoundEvents;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import dev.itsmeow.betteranimalsplus.mixin.DamageSourceInvoker;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1342;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5532;
import net.minecraft.class_7;

public class EntityWalrus
extends class_1429
implements IContainerEntity<EntityWalrus> {
    private static final class_2940<class_2338> HOME_POS = class_2945.method_12791(EntityWalrus.class, (class_2941)class_2943.field_13324);
    private static final class_2940<class_2338> TRAVEL_POS = class_2945.method_12791(EntityWalrus.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> GOING_HOME = class_2945.method_12791(EntityWalrus.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> TRAVELLING = class_2945.method_12791(EntityWalrus.class, (class_2941)class_2943.field_13323);
    public boolean advancementGiven = false;

    public EntityWalrus(class_1299<? extends EntityWalrus> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new MoveHelperController(this);
        this.field_6013 = 1.0f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!this.advancementGiven && stack.method_7909() == ModItems.FRIED_EGG.get()) {
            this.method_6475(player, hand, stack);
            this.field_6002.method_8421((class_1297)this, (byte)90);
            this.advancementGiven = true;
            if (player instanceof class_3222) {
                ModTriggers.WALRUS_EASTER_EGG.trigger((class_3222)player);
            }
            this.method_5783((class_3414)ModSoundEvents.WALRUS_TUNE.get(), 1.0f, 1.0f);
            if (this.field_6002 instanceof class_3218) {
                ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11224, this.method_23317(), this.method_23318(), this.method_23321(), 10, 1.0, 1.0, 1.0, 0.0);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte id) {
        if (id == 90) {
            for (int i = 0; i < 7; ++i) {
                double x = this.field_5974.nextGaussian() * 0.02;
                double y = this.field_5974.nextGaussian() * 0.02;
                double z = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)class_2398.field_11224, this.method_23317() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.nextFloat() * this.method_17682()), this.method_23321() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), x, y, z);
            }
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_6121(class_1297 entityIn) {
        boolean flag = entityIn.method_5643(this.method_6051().nextInt(3) == 0 ? ((DamageSourceInvoker)class_1282.method_5511((class_1309)this)).invokeBypassArmor() : class_1282.method_5511((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194());
        if (flag) {
            class_243 pos = this.method_19538();
            class_243 targetPos = entityIn.method_19538();
            ((class_1309)entityIn).method_6005(0.5, pos.field_1352 - targetPos.field_1352, pos.field_1350 - targetPos.field_1350);
        }
        return flag;
    }

    public void setHome(class_2338 position) {
        this.field_6011.method_12778(HOME_POS, (Object)position);
    }

    private class_2338 getHome() {
        return (class_2338)this.field_6011.method_12789(HOME_POS);
    }

    private void setTravelPos(class_2338 position) {
        this.field_6011.method_12778(TRAVEL_POS, (Object)position);
    }

    private class_2338 getTravelPos() {
        return (class_2338)this.field_6011.method_12789(TRAVEL_POS);
    }

    private boolean isGoingHome() {
        return (Boolean)this.field_6011.method_12789(GOING_HOME);
    }

    private void setGoingHome(boolean isGoingHome) {
        this.field_6011.method_12778(GOING_HOME, (Object)isGoingHome);
    }

    private boolean isTravelling() {
        return (Boolean)this.field_6011.method_12789(TRAVELLING);
    }

    private void setTravelling(boolean isTravelling) {
        this.field_6011.method_12778(TRAVELLING, (Object)isTravelling);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HOME_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(TRAVEL_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(GOING_HOME, (Object)false);
        this.field_6011.method_12784(TRAVELLING, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("HomePosX", this.getHome().method_10263());
        compound.method_10569("HomePosY", this.getHome().method_10264());
        compound.method_10569("HomePosZ", this.getHome().method_10260());
        compound.method_10569("TravelPosX", this.getTravelPos().method_10263());
        compound.method_10569("TravelPosY", this.getTravelPos().method_10264());
        compound.method_10569("TravelPosZ", this.getTravelPos().method_10260());
        compound.method_10556("DiscGiven", this.advancementGiven);
    }

    public void method_5749(class_2487 compound) {
        int i = compound.method_10550("HomePosX");
        int j = compound.method_10550("HomePosY");
        int k = compound.method_10550("HomePosZ");
        this.setHome(new class_2338(i, j, k));
        super.method_5749(compound);
        int l = compound.method_10550("TravelPosX");
        int i1 = compound.method_10550("TravelPosY");
        int j1 = compound.method_10550("TravelPosZ");
        this.setTravelPos(new class_2338(l, i1, j1));
        this.advancementGiven = compound.method_10577("DiscGiven");
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        this.setHome(this.method_24515());
        this.setTravelPos(class_2338.field_10980);
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean canSpawn(class_1299<EntityWalrus> walrus, class_1936 world, class_3730 reason, class_2338 pos, Random rand) {
        return pos.method_10264() < world.method_8615() + 4 && world.method_22335(pos, 0) > 8;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1342((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new GoToWaterGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new GoHomeGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new TravelGoal(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 1.0, false){

            protected double method_6289(class_1309 attackTarget) {
                return this.field_6503.method_17681() * this.field_6503.method_17681() + attackTarget.method_17681();
            }
        });
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new WanderGoal(this, 1.0, 100));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]){

            public boolean method_6264() {
                return EntityWalrus.this.field_6002.method_8407() != class_1267.field_5801 && super.method_6264();
            }
        });
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_6094() {
        return false;
    }

    public int method_5748() {
        return 6000;
    }

    protected int method_6064(int currentAir) {
        return this.method_5748();
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        this.method_5783(class_3417.field_15110, 0.15f, 0.6f);
    }

    protected float method_5867() {
        return this.field_5994 + 0.15f;
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new HybridPathNavigator<EntityWalrus>(this, worldIn, EntityWalrus::isTravelling);
    }

    public float method_6144(class_2338 pos, class_4538 worldIn) {
        if (!this.isGoingHome() && worldIn.method_8316(pos).method_15767((class_3494)class_3486.field_15517)) {
            return 10.0f;
        }
        return worldIn.method_8320(pos.method_10074()).method_26164((class_3494)class_3481.field_15467) ? 10.0f : worldIn.method_22349(pos) - 0.5f;
    }

    public void method_6091(class_243 p_213352_1_) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(0.1f, p_213352_1_);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (!(this.method_5968() != null || this.isGoingHome() && this.getHome().method_19769((class_2374)this.method_19538(), 20.0))) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(p_213352_1_);
        }
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public class_1296 method_5613(class_3218 world, class_1296 ageable) {
        return null;
    }

    public boolean method_5974(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityWalrus getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<? extends EntityWalrus> getContainer() {
        return ModEntities.WALRUS;
    }

    static class MoveHelperController
    extends class_1335 {
        private final EntityWalrus walrus;

        MoveHelperController(EntityWalrus walrus) {
            super((class_1308)walrus);
            this.walrus = walrus;
        }

        private void updateSpeed() {
            if (this.walrus.method_5799()) {
                this.walrus.method_18799(this.walrus.method_18798().method_1031(0.0, 0.005, 0.0));
                if (!this.walrus.getHome().method_19769((class_2374)this.walrus.method_19538(), 16.0)) {
                    this.walrus.method_6125(Math.max(this.walrus.method_6029() / 2.0f, 0.2f));
                }
            } else if (this.walrus.field_5952) {
                this.walrus.method_6125(Math.max(this.walrus.method_6029() / 2.0f, 0.06f));
            }
        }

        public void method_6240() {
            this.updateSpeed();
            if (this.field_6374 == class_1335.class_1336.field_6378 && !this.walrus.method_5942().method_6357()) {
                double d0 = this.field_6370 - this.walrus.method_23317();
                double d1 = this.field_6369 - this.walrus.method_23318();
                double d2 = this.field_6367 - this.walrus.method_23321();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(class_3532.method_15349((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.walrus.method_36456(this.method_6238(this.walrus.method_36454(), f, 90.0f));
                this.walrus.field_6283 = this.walrus.method_36454();
                float f1 = (float)(this.field_6372 * this.walrus.method_5996(class_5134.field_23719).method_6194());
                this.walrus.method_6125(class_3532.method_16439((float)0.125f, (float)this.walrus.method_6029(), (float)f1));
                this.walrus.method_18799(this.walrus.method_18798().method_1031(0.0, (double)this.walrus.method_6029() * d1 * 0.1, 0.0));
            } else {
                this.walrus.method_6125(0.0f);
            }
        }
    }

    public static class GoToWaterGoal
    extends class_1367 {
        private final EntityWalrus walrus;

        public GoToWaterGoal(EntityWalrus walrus, double speed) {
            super((class_1314)walrus, speed, 24);
            this.walrus = walrus;
            this.field_6515 = -1;
        }

        public boolean method_6266() {
            return !this.walrus.method_5799() && this.field_6517 <= 1200 && this.method_6296((class_4538)this.walrus.field_6002, this.field_6512);
        }

        public boolean method_6264() {
            if (this.walrus.method_6109() && !this.walrus.method_5799()) {
                return super.method_6264();
            }
            return !this.walrus.isGoingHome() && !this.walrus.method_5799() && super.method_6264();
        }

        public boolean method_6294() {
            return this.field_6517 % 160 == 0;
        }

        protected boolean method_6296(class_4538 worldIn, class_2338 pos) {
            class_2248 block = worldIn.method_8320(pos).method_26204();
            return block == class_2246.field_10382;
        }
    }

    public static class GoHomeGoal
    extends class_1352 {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;
        private int ticksRan;

        public GoHomeGoal(EntityWalrus walrus, double speedIn) {
            this.walrus = walrus;
            this.speed = speedIn;
        }

        public boolean method_6264() {
            if (this.walrus.method_6109()) {
                return false;
            }
            if (this.walrus.method_6051().nextInt(700) != 0) {
                return false;
            }
            return !this.walrus.getHome().method_19769((class_2374)this.walrus.method_19538(), 64.0);
        }

        public void method_6269() {
            this.walrus.setGoingHome(true);
            this.noPosition = false;
            this.ticksRan = 0;
        }

        public void method_6270() {
            this.walrus.setGoingHome(false);
        }

        public boolean method_6266() {
            return !this.walrus.getHome().method_19769((class_2374)this.walrus.method_19538(), 7.0) && !this.noPosition && this.ticksRan <= 600;
        }

        public void method_6268() {
            class_2338 blockpos = this.walrus.getHome();
            boolean nearHome = blockpos.method_19769((class_2374)this.walrus.method_19538(), 16.0);
            if (nearHome) {
                ++this.ticksRan;
            }
            if (this.walrus.method_5942().method_6357()) {
                class_243 vec3d = class_5532.method_31512((class_1314)this.walrus, (int)16, (int)3, (class_243)new class_243((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260()), (double)0.3141592653589793);
                if (vec3d == null) {
                    vec3d = class_5532.method_31512((class_1314)this.walrus, (int)8, (int)7, (class_243)new class_243((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260()), (double)1.5707963267948966);
                }
                if (vec3d != null && !nearHome && this.walrus.field_6002.method_8320(new class_2338(vec3d)).method_26204() != class_2246.field_10382) {
                    vec3d = class_5532.method_31512((class_1314)this.walrus, (int)16, (int)5, (class_243)new class_243((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260()), (double)1.5707963267948966);
                }
                if (vec3d == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.method_5942().method_6337(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, this.speed);
            }
        }
    }

    public static class TravelGoal
    extends class_1352 {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;

        public TravelGoal(EntityWalrus walrus, double speed) {
            this.walrus = walrus;
            this.speed = speed;
        }

        public boolean method_6264() {
            return !this.walrus.isGoingHome() && this.walrus.method_5799();
        }

        public void method_6269() {
            int xzRange = 512;
            int yRange = 4;
            Random random = this.walrus.field_5974;
            int xOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            int yOff = random.nextInt(yRange * 2 + 1) - yRange;
            int zOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            if ((double)yOff + this.walrus.method_23318() > (double)(this.walrus.field_6002.method_8615() - 1)) {
                yOff = 0;
            }
            class_2338 blockpos = new class_2338((double)xOff + this.walrus.method_23317(), (double)yOff + this.walrus.method_23318(), (double)zOff + this.walrus.method_23321());
            this.walrus.setTravelPos(blockpos);
            this.walrus.setTravelling(true);
            this.noPosition = false;
        }

        public void method_6268() {
            if (this.walrus.method_5942().method_6357()) {
                int z;
                int range;
                int x;
                class_2338 blockpos = this.walrus.getTravelPos();
                class_243 dest = class_5532.method_31512((class_1314)this.walrus, (int)16, (int)3, (class_243)new class_243((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260()), (double)0.3141592653589793);
                if (dest == null) {
                    dest = class_5532.method_31512((class_1314)this.walrus, (int)8, (int)7, (class_243)new class_243((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260()), (double)1.5707963267948966);
                }
                if (dest != null && !this.walrus.field_6002.method_22341((x = class_3532.method_15357((double)dest.field_1352)) - (range = 34), 0, (z = class_3532.method_15357((double)dest.field_1350)) - range, x + range, 0, z + range)) {
                    dest = null;
                }
                if (dest == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.method_5942().method_6337(dest.field_1352, dest.field_1351, dest.field_1350, this.speed);
            }
        }

        public boolean method_6266() {
            return !this.walrus.method_5942().method_6357() && !this.noPosition && !this.walrus.isGoingHome();
        }

        public void method_6270() {
            this.walrus.setTravelling(false);
            super.method_6270();
        }
    }

    public static class WanderGoal
    extends class_1379 {
        private final EntityWalrus walrus;

        public WanderGoal(EntityWalrus walrus, double speed, int chance) {
            super((class_1314)walrus, speed, chance);
            this.walrus = walrus;
        }

        public boolean method_6264() {
            return !this.field_6566.method_5799() && !this.walrus.isGoingHome() && super.method_6264();
        }
    }
}

