/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import java.util.Calendar;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1316;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class EntityReindeer
extends class_1429
implements class_1316,
IVariantTypes<EntityReindeer>,
IDropHead<EntityReindeer> {
    protected static final Predicate<class_1309> IS_REINDEER_BREEDING = entity -> entity instanceof EntityReindeer && ((EntityReindeer)entity).isBreeding();
    private static final class_4051 PARENT_TARGETING = class_4051.method_36626().method_18418(16.0).method_36627().method_18420(IS_REINDEER_BREEDING);
    protected static final class_2940<Byte> STATUS = class_2945.method_12791(EntityReindeer.class, (class_2941)class_2943.field_13319);
    private int eatingCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean reindeerJumping;
    protected float jumpPower;
    private boolean allowStandSliding;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    protected boolean canGallop = true;
    protected int gallopTime;
    public boolean parentRudolph = false;
    public static final String CREATE_SNOW_KEY = "create_snow";

    public EntityReindeer(class_1299<? extends EntityReindeer> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        this.field_6013 = 1.0f;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0, EntityReindeer.class));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.7));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
    }

    protected void method_5693() {
        super.method_5693();
        this.registerTypeKey();
        this.field_6011.method_12784(STATUS, (Object)0);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean flag;
        class_1799 itemstack = player.method_5998(hand);
        boolean bl = flag = !itemstack.method_7960();
        if (flag && itemstack.method_7909() instanceof class_1826) {
            return super.method_5992(player, hand);
        }
        if (!this.method_6109()) {
            if (player.method_18276()) {
                return class_1269.field_5811;
            }
            if (this.method_5782()) {
                return super.method_5992(player, hand);
            }
        }
        if (flag) {
            if (this.handleEating(player, itemstack)) {
                if (!player.method_7337()) {
                    itemstack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (itemstack.method_7920(player, (class_1309)this, hand) == class_1269.field_5812) {
                return class_1269.field_5812;
            }
        }
        if (this.method_6109()) {
            return super.method_5992(player, hand);
        }
        this.mountTo(player);
        return class_1269.field_5812;
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityReindeer)) {
            return false;
        }
        return this.canMate() && ((EntityReindeer)otherAnimal).canMate();
    }

    public class_1296 method_5613(class_3218 world, class_1296 ageable) {
        EntityReindeer reindeer = (EntityReindeer)this.getContainer().getEntityType().method_5883((class_1937)world);
        this.setOffspringAttributes(ageable, reindeer);
        if (ageable instanceof EntityReindeer) {
            EntityReindeer other = (EntityReindeer)ageable;
            if (other.getVariantNameOrEmpty().endsWith("christmas")) {
                reindeer.setType((IVariant)other.getVariant().get());
            } else {
                reindeer.setType((IVariant)this.getVariant().get());
            }
            if (other.method_16914() && other.method_5797().getString().equalsIgnoreCase("rudolph") || this.method_16914() && this.method_5797().getString().equalsIgnoreCase("rudolph")) {
                reindeer.parentRudolph = true;
            }
        } else {
            reindeer.setType((IVariant)this.getVariant().get());
        }
        return reindeer;
    }

    protected boolean getReindeerWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.field_6011.method_12789(STATUS) & p_110233_1_) != 0;
    }

    protected void setReindeerWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.field_6011.method_12789(STATUS);
        if (p_110208_2_) {
            this.field_6011.method_12778(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.field_6011.method_12778(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public boolean isReindeerJumping() {
        return this.reindeerJumping;
    }

    public void setReindeerJumping(boolean jumping) {
        this.reindeerJumping = jumping;
    }

    public boolean method_5931(class_1657 player) {
        return super.method_5931(player);
    }

    protected void method_6142(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public boolean isEatingHaystack() {
        return this.getReindeerWatchableBoolean(16);
    }

    public boolean isRearing() {
        return this.getReindeerWatchableBoolean(32);
    }

    public boolean isBreeding() {
        return this.getReindeerWatchableBoolean(8);
    }

    public void setBreeding(boolean breeding) {
        this.setReindeerWatchableBoolean(8, breeding);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 entity = source.method_5529();
        return (!this.method_5782() || entity == null || !this.method_5626(entity)) && super.method_5643(source, amount);
    }

    public boolean method_5810() {
        return !this.method_5782();
    }

    private void eatingReindeer() {
        this.openReindeerMouth();
        if (!this.method_5701()) {
            this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15099, this.method_5634(), 1.0f, 1.0f + (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f);
        }
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 src) {
        int i;
        if (distance > 1.0f) {
            this.method_5783(class_3417.field_14783, 0.4f, 1.0f);
        }
        if ((i = class_3532.method_15386((float)((distance * 0.5f - 3.0f) * damageMultiplier))) > 0) {
            this.method_5643(class_1282.field_5868, i);
            if (this.method_5782()) {
                for (class_1297 entity : this.method_5736()) {
                    entity.method_5643(class_1282.field_5868, (float)i);
                }
            }
            class_2338 pos = new class_2338(this.method_23317(), this.method_23318() - 0.2 - (double)this.field_5982, this.method_23321());
            class_2680 iblockstate = this.field_6002.method_8320(pos);
            class_2248 block = iblockstate.method_26204();
            if (iblockstate.method_26207() != class_3614.field_15959 && !this.method_5701()) {
                class_2498 soundtype = block.method_9573(block.method_9564());
                this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), soundtype.method_10594(), this.method_5634(), soundtype.method_10597() * 0.5f, soundtype.method_10599() * 0.75f);
            }
        }
        return true;
    }

    public double getReindeerJumpStrength() {
        return this.method_5996(class_5134.field_23728).method_6194();
    }

    protected class_3414 method_6002() {
        this.openReindeerMouth();
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        this.openReindeerMouth();
        if (this.field_5974.nextInt(3) == 0) {
            this.makeReindeerRear();
        }
        return null;
    }

    protected class_3414 method_5994() {
        this.openReindeerMouth();
        if (this.field_5974.nextInt(10) == 0 && !this.method_6062()) {
            this.makeReindeerRear();
        }
        return null;
    }

    protected void method_5712(class_2338 pos, class_2680 blockStateIn) {
        if (!blockStateIn.method_26207().method_15797()) {
            class_2498 soundtype = blockStateIn.method_26231();
            if (this.field_6002.method_8320(pos.method_10084()).method_26204() == class_2246.field_10477) {
                soundtype = class_2246.field_10477.method_9573(class_2246.field_10477.method_9564());
            }
            if (this.method_5782() && this.canGallop) {
                ++this.gallopTime;
                if (this.gallopTime > 5 && this.gallopTime % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopTime <= 5) {
                    this.method_5783(class_3417.field_15061, soundtype.method_10597() * 0.15f, soundtype.method_10599());
                }
            } else if (soundtype == class_2498.field_11547) {
                this.method_5783(class_3417.field_15061, soundtype.method_10597() * 0.15f, soundtype.method_10599());
            } else {
                this.method_5783(class_3417.field_14613, soundtype.method_10597() * 0.15f, soundtype.method_10599());
            }
        }
    }

    protected void playGallopSound(class_2498 p_190680_1_) {
        this.method_5783(class_3417.field_14987, p_190680_1_.method_10597() * 0.15f, p_190680_1_.method_10599());
    }

    public int method_5945() {
        return 6;
    }

    protected float method_6107() {
        return 0.8f;
    }

    public int method_5970() {
        return 400;
    }

    protected boolean handleEating(class_1657 player, class_1799 stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8861 || item == class_1802.field_8179) {
            f = 2.0f;
            i = 20;
            if (!this.method_6109() && !this.method_6479()) {
                flag = true;
                this.method_6480(player);
            }
        } else if (item == class_1802.field_8479) {
            f = 1.0f;
            i = 30;
        } else if (item == class_2246.field_10359.method_8389()) {
            f = 20.0f;
            i = 180;
        } else if (item == class_1802.field_8279) {
            f = 3.0f;
            i = 60;
        } else if (item == class_1802.field_8071) {
            f = 4.0f;
            i = 60;
            if (this.method_5618() == 0 && !this.method_6479()) {
                flag = true;
                this.method_6480(player);
            }
        } else if (item == class_1802.field_8463) {
            f = 10.0f;
            i = 240;
            if (this.method_5618() == 0 && !this.method_6479()) {
                flag = true;
                this.method_6480(player);
            }
        }
        if (this.method_6032() < this.method_6063() && f > 0.0f) {
            this.method_6025(f);
            flag = true;
        }
        if (this.method_6109() && i > 0) {
            this.field_6002.method_8406((class_2394)class_2398.field_11211, this.method_23317() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.nextFloat() * this.method_17682()), this.method_23321() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), 0.0, 0.0, 0.0);
            if (!this.field_6002.field_9236) {
                this.method_5615(i);
            }
            flag = true;
        }
        if (flag) {
            this.eatingReindeer();
        }
        return flag;
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        this.doHeadDrop();
    }

    protected void mountTo(class_1657 player) {
        player.method_36456(this.method_36454());
        player.method_36457(this.method_36455());
        this.setEatingHaystack(false);
        this.setRearing(false);
        if (player instanceof class_3222) {
            ModTriggers.RIDE_REINDEER.trigger((class_3222)player);
        }
        if (!this.field_6002.field_9236) {
            player.method_5804((class_1297)this);
        }
    }

    protected boolean method_6062() {
        return super.method_6062() && this.method_5782() || this.isEatingHaystack() || this.isRearing();
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public void method_6007() {
        if (this.field_5974.nextInt(200) == 0) {
            this.moveTail();
        }
        super.method_6007();
        if (this.field_6002.method_8608() && this.getContainer().getCustomConfigurationClient().getBoolean(CREATE_SNOW_KEY) && this.field_5974.nextInt(10) == 0) {
            this.field_6002.method_8406((class_2394)class_2398.field_11203, this.method_23317() + (double)this.field_5974.nextInt(4) - 2.0, this.method_23318() + (double)this.field_5974.nextInt(4), this.method_23321() + (double)this.field_5974.nextInt(4) - 2.0, 0.0, (double)-0.2f, 0.0);
        }
        if (!this.field_6002.field_9236) {
            if (this.field_5974.nextInt(900) == 0 && this.field_6213 == 0) {
                this.method_6025(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEatingHaystack() && !this.method_5782() && this.field_5974.nextInt(300) == 0 && this.field_6002.method_8320(new class_2338(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.method_23318()) - 1, class_3532.method_15357((double)this.method_23321()))).method_26204() == class_2246.field_10479) {
                    this.setEatingHaystack(true);
                }
                if (this.isEatingHaystack() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEatingHaystack(false);
                }
            }
            this.followMother();
        }
    }

    protected void followMother() {
        class_1309 livingentity;
        if (this.isBreeding() && this.method_6109() && !this.isEatingHaystack() && (livingentity = this.field_6002.method_21726(class_1496.class, PARENT_TARGETING, (class_1309)this, this.method_23317(), this.method_23318(), this.method_23321(), this.method_5829().method_1014(16.0))) != null && this.method_5858((class_1297)livingentity) > 4.0) {
            this.field_6189.method_6349((class_1297)livingentity, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    public void method_5773() {
        super.method_5773();
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setReindeerWatchableBoolean(64, false);
        }
        if (this.method_5787() && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.prevHeadLean = this.headLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getReindeerWatchableBoolean(64)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openReindeerMouth() {
        if (!this.field_6002.field_9236) {
            this.openMouthCounter = 1;
            this.setReindeerWatchableBoolean(64, true);
        }
    }

    public void setEatingHaystack(boolean p_110227_1_) {
        this.setReindeerWatchableBoolean(16, p_110227_1_);
    }

    public void setRearing(boolean rearing) {
        if (rearing) {
            this.setEatingHaystack(false);
        }
        this.setReindeerWatchableBoolean(32, rearing);
    }

    private void makeReindeerRear() {
        if (this.method_5787()) {
            this.jumpRearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void method_6091(class_243 vec) {
        if (this.method_5782() && this.method_5956()) {
            double d0;
            class_1309 entitylivingbase = (class_1309)this.method_5642();
            this.method_36456(entitylivingbase.method_36454());
            this.field_5982 = this.method_36454();
            this.method_36457(entitylivingbase.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.field_6241 = this.field_6283 = this.method_36454();
            vec = vec.method_1031((double)(entitylivingbase.field_6212 * 0.5f) - vec.field_1352, vec.field_1351, vec.field_1350);
            vec = vec.method_1031(vec.field_1352, vec.field_1351, (double)entitylivingbase.field_6250 - vec.field_1350);
            if (vec.field_1350 <= 0.0) {
                vec = vec.method_18805(1.0, 1.0, 0.25);
                this.gallopTime = 0;
            }
            if (this.field_5952 && this.jumpPower == 0.0f && this.isRearing() && !this.allowStandSliding) {
                vec = vec.method_18805(0.0, 1.0, 0.0);
            }
            if (this.jumpPower > 0.0f && !this.isReindeerJumping() && this.field_5952) {
                this.method_18799(this.method_18798().method_1031(0.0, this.getReindeerJumpStrength() * (double)this.jumpPower - this.method_18798().field_1351, 0.0));
                if (this.method_6059(class_1294.field_5913)) {
                    this.method_18799(this.method_18798().method_1031(0.0, (double)((float)(this.method_6112(class_1294.field_5913).method_5578() + 1) * 0.1f), 0.0));
                }
                this.setReindeerJumping(true);
                this.field_6007 = true;
                if (vec.field_1350 > 0.0) {
                    float f = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
                    float f1 = class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
                    this.method_18799(this.method_18798().method_1031((double)(-0.4f * f * this.jumpPower), 0.0, (double)(0.4f * f1 * this.jumpPower)));
                    this.method_5783(class_3417.field_14831, 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.field_6281 = this.method_6029() * 0.1f;
            if (this.method_5787()) {
                this.method_6125((float)this.method_5996(class_5134.field_23719).method_6194());
                super.method_6091(vec);
            } else if (entitylivingbase instanceof class_1657) {
                this.method_18800(0.0, 0.0, 0.0);
            }
            if (this.field_5952) {
                this.jumpPower = 0.0f;
                this.setReindeerJumping(false);
            }
            this.field_6211 = this.field_6225;
            double d1 = this.method_23317() - this.field_6014;
            double f2 = Math.sqrt(d1 * d1 + (d0 = this.method_23321() - this.field_5969) * d0) * 4.0;
            if (f2 > 1.0) {
                f2 = 1.0;
            }
            this.field_6225 = (float)((double)this.field_6225 + (f2 - (double)this.field_6225) * (double)0.4f);
            this.field_6249 += this.field_6225;
        } else {
            this.field_6281 = 0.02f;
            super.method_6091(vec);
        }
    }

    public void method_5665(class_2561 comp) {
        if (comp.getString().equalsIgnoreCase("rudolph") && this.getVariant().isPresent() && !this.getVariantNameOrEmpty().endsWith("_christmas")) {
            this.setType(this.getVariantNameOrEmpty() + "_christmas");
        }
        super.method_5665(comp);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("EatingHaystack", this.isEatingHaystack());
        compound.method_10556("Bred", this.isBreeding());
        this.writeType(compound);
        compound.method_10556("IsParentRudolph", this.parentRudolph);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setEatingHaystack(compound.method_10577("EatingHaystack"));
        this.setBreeding(compound.method_10577("Bred"));
        this.parentRudolph = compound.method_10577("IsParentRudolph");
        this.readType(compound);
        Calendar calendar = Calendar.getInstance();
        if (!(!this.getVariantNameOrEmpty().endsWith("_christmas") || calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28 || this.method_5797().getString().equalsIgnoreCase("rudolph") || this.parentRudolph)) {
            this.setType(this.getVariantNameOrEmpty().substring(0, 1));
        }
    }

    protected boolean canMate() {
        return !this.method_5782() && this.method_5854() == null && !this.method_6109() && this.method_6032() >= this.method_6063() && this.method_6479();
    }

    protected void setOffspringAttributes(class_1296 p_190681_1_, EntityReindeer p_190681_2_) {
        double d0 = this.method_26826(class_5134.field_23716) + p_190681_1_.method_26826(class_5134.field_23716) + (double)this.getModifiedMaxHealth();
        p_190681_2_.method_5996(class_5134.field_23716).method_6192(d0 / 3.0);
        double d1 = this.method_26826(class_5134.field_23728) + p_190681_1_.method_26826(class_5134.field_23728) + this.getModifiedJumpStrength();
        p_190681_2_.method_5996(class_5134.field_23728).method_6192(d1 / 3.0);
        double d2 = this.method_26826(class_5134.field_23719) + p_190681_1_.method_26826(class_5134.field_23719) + this.getModifiedMovementSpeed();
        p_190681_2_.method_5996(class_5134.field_23719).method_6192(d2 / 3.0);
    }

    public boolean method_5956() {
        return this.method_5642() instanceof class_1309;
    }

    @Environment(value=EnvType.CLIENT)
    public float getGrassEatingAmount(float p_110258_1_) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * p_110258_1_;
    }

    @Environment(value=EnvType.CLIENT)
    public float getRearingAmount(float p_110223_1_) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * p_110223_1_;
    }

    @Environment(value=EnvType.CLIENT)
    public float getMouthOpennessAngle(float p_110201_1_) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * p_110201_1_;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_6154(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        } else {
            this.allowStandSliding = true;
            this.makeReindeerRear();
        }
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    public boolean method_6153() {
        return true;
    }

    public void method_6155(int p_184775_1_) {
        this.allowStandSliding = true;
        this.makeReindeerRear();
    }

    public void method_6156() {
    }

    @Environment(value=EnvType.CLIENT)
    protected void spawnReindeerParticles(boolean p_110216_1_) {
        class_2400 enumparticletypes = p_110216_1_ ? class_2398.field_11201 : class_2398.field_11251;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_5974.nextGaussian() * 0.02;
            double d1 = this.field_5974.nextGaussian() * 0.02;
            double d2 = this.field_5974.nextGaussian() * 0.02;
            this.field_6002.method_8406((class_2394)enumparticletypes, this.method_23317() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.nextFloat() * this.method_17682()), this.method_23321() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d1, d2);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte id) {
        if (id == 7) {
            this.spawnReindeerParticles(true);
        } else if (id == 6) {
            this.spawnReindeerParticles(false);
        } else {
            super.method_5711(id);
        }
    }

    public void method_5865(class_1297 passenger) {
        super.method_5865(passenger);
        if (passenger instanceof class_1308) {
            class_1308 entityliving = (class_1308)passenger;
            this.field_6283 = entityliving.field_6283;
        }
        if (this.prevRearingAmount > 0.0f) {
            float f3 = class_3532.method_15374((float)(this.field_6283 * ((float)Math.PI / 180)));
            float f = class_3532.method_15362((float)(this.field_6283 * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.prevRearingAmount;
            float f2 = 0.15f * this.prevRearingAmount;
            passenger.method_5814(this.method_23317() + (double)(f1 * f3), this.method_23318() + this.method_5621() + passenger.method_5678() + (double)f2, this.method_23321() - (double)(f1 * f));
            if (passenger instanceof class_1309) {
                ((class_1309)passenger).field_6283 = this.field_6283;
            }
        }
    }

    protected float getModifiedMaxHealth() {
        return 15.0f + (float)this.field_5974.nextInt(8) + (float)this.field_5974.nextInt(9);
    }

    protected double getModifiedJumpStrength() {
        return (double)0.4f + this.field_5974.nextDouble() * 0.2 + this.field_5974.nextDouble() * 0.2 + this.field_5974.nextDouble() * 0.2;
    }

    protected double getModifiedMovementSpeed() {
        return ((double)0.45f + this.field_5974.nextDouble() * 0.3 + this.field_5974.nextDouble() * 0.3 + this.field_5974.nextDouble() * 0.3) * 0.25;
    }

    public boolean method_6101() {
        return false;
    }

    public class_1297 method_5642() {
        return this.method_5685().isEmpty() ? null : (class_1297)this.method_5685().get(0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 reason, class_1315 livingdata, class_2487 compound) {
        this.method_5996(class_5134.field_23716).method_6192((double)this.getModifiedMaxHealth());
        this.method_5996(class_5134.field_23719).method_6192(this.getModifiedMovementSpeed());
        this.method_5996(class_5134.field_23728).method_6192(this.getModifiedJumpStrength());
        return this.initAgeableData((class_1936)world, reason, super.method_5943(world, difficulty, reason, livingdata, compound));
    }

    @Override
    public IVariant getRandomType() {
        Calendar calendar = Calendar.getInstance();
        boolean isChristmasSeason = calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28;
        boolean redNosed = this.field_5974.nextInt(9) == 0;
        return this.getContainer().getVariantForName(this.field_5974.nextInt(4) + 1 + (isChristmasSeason && redNosed ? "_christmas" : "")).orElse(IVariantTypes.super.getRandomType());
    }

    public boolean method_5974(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityReindeer getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<EntityReindeer> getContainer() {
        return ModEntities.REINDEER;
    }

    @Override
    public void doHeadDrop() {
        this.getHeadType().drop((class_1308)this, 12, this.getContainer().getVariantForName(this.getVariantNameOrEmpty().substring(0, 1)).get());
    }
}

