/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypesAndSizeContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import net.minecraft.class_5431;

public class EntityDragonfly
extends EntityAnimalWithTypesAndSizeContainable {
    private static final class_2940<Integer> LANDED = class_2945.method_12791(EntityDragonfly.class, (class_2941)class_2943.field_13327);
    private static final class_4051 playerPredicate = class_4051.method_36626().method_18418(4.0).method_36627();
    private class_2338 targetPosition;
    private int rainTicks = 0;

    public EntityDragonfly(class_1299<? extends EntityDragonfly> entityType, class_1937 worldIn) {
        super((class_1299<? extends EntityAnimalWithTypesAndSizeContainable>)entityType, worldIn);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LANDED, (Object)1);
    }

    public boolean method_5679(class_1282 source) {
        return super.method_5679(source) || source == class_1282.field_16992;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entityIn) {
    }

    protected void method_6070() {
    }

    public boolean isLanded() {
        return (Integer)this.field_6011.method_12789(LANDED) != 1;
    }

    public int getLandedInteger() {
        return (Integer)this.field_6011.method_12789(LANDED);
    }

    public void setLanded(class_2350 direction) {
        if (direction == class_2350.field_11036) {
            throw new RuntimeException("Invalid landing direction!");
        }
        this.field_6011.method_12778(LANDED, (Object)direction.ordinal());
    }

    public void setNotLanded() {
        this.field_6011.method_12778(LANDED, (Object)1);
        this.method_5859((double)this.method_24515().method_10263() + 0.5, (double)this.method_24515().method_10264() + 0.5, (double)this.method_24515().method_10260() + 0.5);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public void method_5773() {
        super.method_5773();
        if (this.isLanded()) {
            this.method_18799(class_243.field_1353);
            if (class_2350.method_10143((int)this.getLandedInteger()) != class_2350.field_11033) {
                double x = Math.floor(this.method_23317()) + 0.5;
                double z = Math.floor(this.method_23321()) + 0.5;
                class_2338 pos = new class_2338(x, Math.floor(this.method_23318()) + 0.5, z);
                class_2338 offset = pos.method_10093(class_2350.method_10143((int)this.getLandedInteger()));
                class_2338 diff = pos.method_10059((class_2382)offset);
                this.method_5859(x - (double)diff.method_10263() / 2.778, Math.floor(this.method_23318()) + 0.5, z - (double)diff.method_10260() / 2.778);
                this.method_36456(0.0f);
                this.field_6241 = 0.0f;
            } else {
                this.method_5859(this.method_23317(), Math.floor(this.method_23318()), this.method_23321());
            }
        } else {
            this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
        }
    }

    public boolean isRainingAt(class_2338 position) {
        if (!this.field_6002.method_8419()) {
            return false;
        }
        if (position == null) {
            return true;
        }
        if (!this.field_6002.method_8477(position) || !this.field_6002.method_22348(position)) {
            return false;
        }
        return this.field_6002.method_23753(position).method_8694() == class_1959.class_1963.field_9382;
    }

    protected void method_5958() {
        super.method_5958();
        class_2338 blockpos = this.method_24515();
        if (this.isLanded()) {
            class_2350 direction = class_2350.method_10143((int)this.getLandedInteger());
            class_2350[] offset = blockpos.method_10093(direction);
            if (this.field_6002.method_8320((class_2338)offset).method_30368((class_1922)this.field_6002, (class_2338)offset, direction.method_10153(), class_5431.field_25823)) {
                if (this.field_6002.method_18462(playerPredicate, (class_1309)this) != null || this.method_6051().nextInt(500) == 0) {
                    this.setNotLanded();
                }
            } else {
                this.setNotLanded();
            }
        }
        if (this.isRainingAt(this.method_24515())) {
            ++this.rainTicks;
            if (this.isLanded()) {
                this.setNotLanded();
            }
            if (this.targetPosition == null || this.isRainingAt(this.targetPosition)) {
                this.targetPosition = this.tryToFindPositionBlock(pos -> {
                    if (pos != null && !this.isRainingAt((class_2338)pos) && this.field_6002.method_22347(pos)) {
                        for (class_2350 direction : class_2350.values()) {
                            class_2338 offset;
                            if (direction == class_2350.field_11036 || !this.field_6002.method_8320(offset = pos.method_10093(direction)).method_30368((class_1922)this.field_6002, offset, direction.method_10153(), class_5431.field_25823)) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                });
            }
            if (this.method_6051().nextFloat() < 0.0025f && this.rainTicks > 100) {
                this.method_5643(class_1282.field_5859, 1.0f);
            }
        } else {
            this.rainTicks = 0;
            if (this.targetPosition == null || this.field_5974.nextInt(30) == 0 || this.targetPosition.method_19769((class_2374)this.method_19538(), 1.0)) {
                if (this.field_6002.method_8419() && this.field_6002.method_23753(this.method_24515()).method_8694() == class_1959.class_1963.field_9382) {
                    class_2338 temp;
                    boolean found = false;
                    for (class_2350 direction : class_2350.values()) {
                        class_2338 offset;
                        if (direction == class_2350.field_11036 || !this.field_6002.method_8320(offset = blockpos.method_10093(direction)).method_30368((class_1922)this.field_6002, offset, direction.method_10153(), class_5431.field_25823) || !this.field_6002.method_22347(blockpos)) continue;
                        this.setLanded(direction);
                        this.targetPosition = null;
                        found = true;
                        break;
                    }
                    if (!found && !this.isRainingAt(temp = new class_2338(this.method_23317() + (double)this.field_5974.nextInt(5) - (double)this.field_5974.nextInt(5), this.method_23318() + (double)this.field_5974.nextInt(4) - 1.0, this.method_23321() + (double)this.field_5974.nextInt(5) - (double)this.field_5974.nextInt(5)))) {
                        this.targetPosition = temp;
                    }
                } else {
                    boolean found = false;
                    if (this.field_6002.method_18462(playerPredicate, (class_1309)this) == null) {
                        for (class_2350 direction : class_2350.values()) {
                            class_2338 offset;
                            if (direction == class_2350.field_11036 || !this.field_6002.method_8320(offset = blockpos.method_10093(direction)).method_30368((class_1922)this.field_6002, offset, direction.method_10153(), class_5431.field_25823) || !this.field_6002.method_22347(blockpos)) continue;
                            this.setLanded(direction);
                            this.targetPosition = null;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        for (int attempts = 0; !(attempts >= 5 || this.targetPosition != null && this.field_6002.method_22347(this.targetPosition)); ++attempts) {
                            this.targetPosition = new class_2338(this.method_23317() + (double)this.field_5974.nextInt(5) - (double)this.field_5974.nextInt(5), this.method_23318() + (double)this.field_5974.nextInt(4) - 1.0, this.method_23321() + (double)this.field_5974.nextInt(5) - (double)this.field_5974.nextInt(5));
                        }
                    }
                }
            }
            if (this.targetPosition != null && this.targetPosition.method_19769((class_2374)this.method_19538(), 1.0)) {
                this.targetPosition = null;
            }
        }
        if (!this.isLanded() && this.targetPosition != null) {
            if (this.method_5757()) {
                this.targetPosition = this.tryToFindPositionSlow(pos -> {
                    class_238 abb = this.method_5829();
                    class_243 diff = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5).method_1020(this.method_19538());
                    double length = diff.method_1033();
                    diff = diff.method_1029();
                    int i = 1;
                    while ((double)i < length) {
                        if (!this.field_6002.method_8587((class_1297)this, abb = abb.method_997(diff))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                });
            }
            double d0 = (double)this.targetPosition.method_10263() + 0.5 - this.method_23317();
            double d1 = (double)this.targetPosition.method_10264() + 0.1 - this.method_23318();
            double d2 = (double)this.targetPosition.method_10260() + 0.5 - this.method_23321();
            class_243 vec3d = this.method_18798();
            class_243 vec3d1 = vec3d.method_1031((Math.signum(d0) * 0.5 - vec3d.field_1352) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_1351) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_1350) * (double)0.1f);
            this.method_18799(vec3d1);
            float f = (float)(class_3532.method_15349((double)vec3d1.field_1350, (double)vec3d1.field_1352) * 57.2957763671875) - 90.0f;
            float f1 = class_3532.method_15393((float)(f - this.method_36454()));
            this.field_6250 = 0.5f;
            this.method_36456(this.method_36454() + f1);
        }
    }

    private class_2338 tryToFindPositionBlock(Predicate<class_2338> condition) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int i = 12;
        int j = 2;
        int k = 0;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        pos.method_10101((class_2382)this.method_24515()).method_10100(i1, k - 1, j1);
                        if (condition.test(pos.method_10062())) {
                            return pos.method_10062();
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return null;
    }

    private class_2338 tryToFindPositionSlow(Predicate<class_2338> condition) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int i = 12;
        int j = 2;
        boolean down = false;
        while (!down) {
            int k;
            int n = k = down ? -1 : 0;
            while (down ? k >= -j : k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n2 = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            pos.method_10101((class_2382)this.method_24515()).method_10100(i1, k, j1);
                            if (condition.test(pos.method_10062())) {
                                return pos.method_10062();
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k += down ? -1 : 1;
            }
            down = true;
        }
        return null;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public boolean method_5696() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.field_6002.field_9236 && this.isLanded()) {
            this.setNotLanded();
        }
        return super.method_5643(source, amount);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(LANDED, (Object)compound.method_10550("Landed"));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Landed", ((Integer)this.field_6011.method_12789(LANDED)).intValue());
    }

    @Override
    protected float getRandomizedSize() {
        return ((float)this.field_5974.nextInt(30) + 1.0f) / 100.0f + 0.15f;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    @Override
    public EntityTypeContainer<? extends EntityDragonfly> getContainer() {
        return ModEntities.DRAGONFLY;
    }

    @Override
    protected EntityAnimalWithTypes getBaseChild() {
        return null;
    }

    public EntityTypeContainerContainable<? extends EntityDragonfly, ?> getContainableContainer() {
        return ModEntities.DRAGONFLY;
    }

    @Override
    public void setContainerData(class_1799 bucket) {
        super.setContainerData(bucket);
        class_2487 tag = bucket.method_7969();
        tag.method_10548("SizeTag", ((Float)this.field_6011.method_12789(SIZE)).floatValue());
        bucket.method_7980(tag);
    }

    @Override
    public void readFromContainerTag(class_2487 tag) {
        super.readFromContainerTag(tag);
        if (tag.method_10545("SizeTag")) {
            this.setSize(tag.method_10583("SizeTag"));
        }
    }

    public static void bottleTooltip(EntityTypeContainer<? extends class_1308> container, class_1799 stack, class_1937 worldIn, List<class_2561> tooltip) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("SizeTag", 5)) {
            tooltip.add((class_2561)new class_2585("Size: " + tag.method_10583("SizeTag")).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
        }
    }
}

