/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryHUDGui;
import dlovin.inventoryhud.utils.TrinketSlot;
import dlovin.inventoryhud.utils.TrinketSlots;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class TrinketSaveUtils {
    private static final String path = FabricLoader.getInstance().getConfigDir() + "/InventoryHUD/curios.json";

    public static void saveFile(String input) {
        File file = new File(path);
        TrinketSaveUtils.saveFile(file, input);
    }

    private static void saveFile(File file, String input) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(input);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void saveSettings() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, TrinketSlot> entry : InventoryHUD.getInstance().getInvhudGUI().slots.entrySet()) {
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)entry.getValue().x);
            tmpObject.addProperty("y", (Number)entry.getValue().y);
            tmpObject.addProperty("halign", entry.getValue().aligns.HorAlign.name());
            tmpObject.addProperty("valign", entry.getValue().aligns.VertAlign.name());
            tmpObject.addProperty("enabled", Boolean.valueOf(entry.getValue().enabled));
            obj.add(entry.getKey(), (JsonElement)tmpObject);
        }
        TrinketSaveUtils.saveFile(obj.toString());
    }

    public static void loadFromFile(InventoryHUDGui gui) {
        File file = new File(path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            TrinketSaveUtils.saveFile(file, TrinketSaveUtils.getDefault());
        }
        JsonParser jsonParser = new JsonParser();
        try (FileReader reader = new FileReader(file);){
            JsonElement obj = jsonParser.parse((Reader)reader);
            JsonObject list = TrinketSaveUtils.checkTypes(obj.getAsJsonObject());
            TrinketSaveUtils.setTypes(gui, list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setTypes(InventoryHUDGui gui, JsonObject obj) {
        for (Map.Entry el : obj.entrySet()) {
            int x = ((JsonElement)el.getValue()).getAsJsonObject().get("x").getAsInt();
            int y = ((JsonElement)el.getValue()).getAsJsonObject().get("y").getAsInt();
            WidgetAligns.HAlign hAlign = WidgetAligns.HAlign.valueOf(((JsonElement)el.getValue()).getAsJsonObject().get("halign").getAsString());
            WidgetAligns.VAlign vAlign = WidgetAligns.VAlign.valueOf(((JsonElement)el.getValue()).getAsJsonObject().get("valign").getAsString());
            boolean enabled = ((JsonElement)el.getValue()).getAsJsonObject().get("enabled").getAsBoolean();
            gui.slots.put((String)el.getKey(), new TrinketSlot(x, y, new WidgetAligns(hAlign, vAlign), enabled, (String)el.getKey()));
        }
    }

    private static String getDefault() {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < TrinketSlots.values().length; ++i) {
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)0);
            tmpObject.addProperty("y", (Number)(i * 20));
            tmpObject.addProperty("halign", "LEFT");
            tmpObject.addProperty("valign", "TOP");
            tmpObject.addProperty("enabled", Boolean.valueOf(false));
            obj.add(TrinketSlots.values()[i].name(), (JsonElement)tmpObject);
        }
        return obj.toString();
    }

    private static JsonObject checkTypes(JsonObject obj) {
        boolean save = false;
        for (int i = 0; i < TrinketSlots.values().length; ++i) {
            if (obj.get(TrinketSlots.values()[i].name()) != null) continue;
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)(i * 48));
            tmpObject.addProperty("y", (Number)0);
            tmpObject.addProperty("halign", "LEFT");
            tmpObject.addProperty("valign", "TOP");
            tmpObject.addProperty("enabled", Boolean.valueOf(false));
            obj.add(TrinketSlots.values()[i].name(), (JsonElement)tmpObject);
            save = true;
        }
        if (save) {
            TrinketSaveUtils.saveFile(obj.toString());
        }
        return obj;
    }
}

