/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.gui.ConfigScreen;
import dlovin.inventoryhud.config.widgets.CustomButton;
import dlovin.inventoryhud.config.widgets.NumericTextField;
import dlovin.inventoryhud.config.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.class_124;
import net.minecraft.class_437;

public class PotionConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private CustomButton HorModeBtn;
    private NumericTextField AlphaField;
    private NumericTextField GapField;
    private NumericTextField BarField;

    public PotionConfigScreen(class_437 prev, boolean inGame) {
        super(prev, 2, inGame);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        String toggle = InventoryHUD.getConfig().getPot() ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, toggle, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.ToggleBtn.addListener(this::ToggleSwitch);
        this.MiniModeBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, "" + InventoryHUD.getConfig().getPotMini(), null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        this.MiniModeBtn.addListener(this::MiniModeSwitch);
        this.HorModeBtn = new CustomButton(this.field_22789 / 2 + 20, 0, 40, 20, "" + InventoryHUD.getConfig().isPotHor(), null, false);
        this.OptionList.addWidget(this.HorModeBtn, 3);
        this.HorModeBtn.addListener(this::HorModeSwitch);
        this.AlphaField = new NumericTextField(this.field_22793, this.field_22789 / 2 + 20, 0, 40, 20, 0, 100, InventoryHUD.getConfig().getPotAlpha(), tf -> this.AlphaChanged());
        this.OptionList.addWidget(this.AlphaField, 1);
        this.GapField = new NumericTextField(this.field_22793, this.field_22789 / 2 + 20, 0, 40, 20, -5, 5, InventoryHUD.getConfig().getPotGap(), tf -> this.GapChanged());
        this.OptionList.addWidget(this.GapField, 4);
        this.BarField = new NumericTextField(this.field_22793, this.field_22789 / 2 + 20, 0, 40, 20, 1, Integer.MAX_VALUE, InventoryHUD.getConfig().getBarDuration(), tf -> this.BarChanged());
        this.OptionList.addWidget(this.BarField, 5);
        this.AlphaField.setMaxStringLength(5);
        this.GapField.setMaxStringLength(3);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_TOGGLE.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.POT_TOGGLE_TT, x, y)), 0);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_ALPHA.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.POT_ALPHA_TT, x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_MINI.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.POT_MINI_TT, x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_HOR.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.POT_HOR_TT, x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_GAP.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.POT_GAP_TT, x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.field_22789 / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.BAR_DUR.getString(), this.field_22793, (w, m, x, y) -> this.method_25424(m, Translation.BAR_DUR_TT, x, y)), 5);
    }

    private void BarChanged() {
        int a;
        try {
            a = Integer.parseInt(this.BarField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.barDuration = a * 20;
        InventoryHUD.getConfig().setBarDuration(a);
        InventoryHUD.save();
    }

    private void HorModeSwitch() {
        Boolean hor = !InventoryHUD.getConfig().isPotHor();
        InventoryHUD.getConfig().setPotHor(hor);
        InventoryHUD.getInstance().getInvhudGUI().changePotionHor(hor);
        this.HorModeBtn.setMessage(hor.toString());
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.PotPosChanged();
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.potAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig().setPotAlpha(a);
        InventoryHUD.save();
    }

    private void GapChanged() {
        int a;
        try {
            a = Integer.parseInt(this.GapField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.potGap = a;
        InventoryHUD.getConfig().setPotGap(a);
    }

    private void ToggleSwitch() {
        boolean potion;
        InventoryHUD.PotHUD = potion = !InventoryHUD.getConfig().getPot();
        InventoryHUD.getConfig().setPot(potion);
        String toggle = potion ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn.setMessage(toggle);
    }

    private void MiniModeSwitch() {
        boolean mini = !InventoryHUD.getConfig().getPotMini();
        InventoryHUD.getConfig().setPotMini(mini);
        InventoryHUD.getInstance().getInvhudGUI().changePotionMini(mini);
        this.MiniModeBtn.setMessage("" + mini);
        InventoryHUD.getInstance().getInvhudGUI().potionRenderer.PotPosChanged();
    }
}

