/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_897;
import net.minecraft.class_898;
import xaero.common.AXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIcon;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconManager {
    public static final EntityIcon FAILED = new EntityIcon(null, 0, 0);
    public static final EntityIcon DOT = new EntityIcon(null, 0, 0);
    private EntityIconPrerenderer prerenderer;
    private final AXaeroMinimap modMain;
    private Map<class_2960, EntityIconDefinition> iconDefinitions;
    private Map<String, EntityIcon> cachedTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;
    private EntityIconModelConfig defaultModelConfig;

    public EntityIconManager(AXaeroMinimap modMain, EntityIconPrerenderer prerenderer) {
        this.modMain = modMain;
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<class_2960, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, EntityIcon>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
        this.defaultModelConfig = new EntityIconModelConfig();
    }

    protected String getSavedEntityId(class_1297 e) {
        class_1299 entityType = e.method_5864();
        class_2960 identifier = class_1299.method_5890((class_1299)entityType);
        return entityType.method_5893() && identifier != null ? identifier.toString() : null;
    }

    public <T extends class_1297> EntityIcon getEntityHeadTexture(T entity, class_276 defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean debug, boolean debugEntityVariantIds) {
        String cacheKey;
        EntityIcon cachedValue;
        class_1309 livingEntity;
        class_1799 headItemStack;
        class_2960 entityId = class_1299.method_5890((class_1299)entity.method_5864());
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        class_898 renderManager = class_310.method_1551().method_1561();
        class_897 entityRenderer = renderManager.method_3953(entity);
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        boolean variantIdAppended = false;
        if (iconDefinition != null) {
            Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
            if (variantIdBuilderMethod != null) {
                try {
                    variantIdBuilderMethod.invoke(null, entityStringBuilder, entityRenderer, entity);
                    variantIdAppended = true;
                }
                catch (Exception e) {
                    MinimapLogs.LOGGER.error("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId, (Throwable)e);
                    iconDefinition.setVariantIdBuilderMethod(null);
                }
            } else {
                Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
                if (variantOldIdMethod != null) {
                    try {
                        String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                        entityStringBuilder.append(entityVariantString);
                        variantIdAppended = true;
                    }
                    catch (Exception e) {
                        MinimapLogs.LOGGER.error("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId, (Throwable)e);
                        iconDefinition.setOldVariantIdMethod(null);
                    }
                }
            }
        }
        if (!variantIdAppended) {
            EntityIconDefinitions.buildVariantIdString(entityStringBuilder, entityRenderer, entity);
        }
        String entityVariantString = entityStringBuilder.toString();
        entityStringBuilder.append("%").append(this.getSavedEntityId(entity));
        if (entity instanceof class_1309 && !(entity instanceof class_1657) && (headItemStack = (livingEntity = (class_1309)entity).method_6118(class_1304.field_6169)) != null && headItemStack != class_1799.field_8037) {
            entityStringBuilder.append("%").append(class_2378.field_11142.method_10221((Object)headItemStack.method_7909()));
        }
        if ((cachedValue = this.cachedTextures.get(cacheKey = entityStringBuilder.toString())) == null) {
            class_2960 iconType;
            if (debugEntityVariantIds) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)new class_2585(entityVariantString));
            }
            String variantMapKey = entityVariantString;
            if (iconDefinition != null) {
                iconType = iconDefinition.getVariantType(variantMapKey);
                if (iconType == null) {
                    variantMapKey = "default";
                    iconType = iconDefinition.getVariantType(variantMapKey);
                }
            } else {
                iconType = EntityIconDefinition.MODEL_TYPE;
            }
            if (iconType == EntityIconDefinition.MODEL_TYPE) {
                if (this.canPrerender) {
                    EntityIconModelConfig variantModelConfig;
                    EntityIconModelConfig modelConfig = this.defaultModelConfig;
                    EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                    if (variantModelConfig != null) {
                        modelConfig = variantModelConfig;
                    }
                    cachedValue = this.prerenderer.prerender(cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, null, true, false, debug);
                    this.cachedTextures.put(cacheKey, cachedValue);
                    this.canPrerender = false;
                } else {
                    cachedValue = null;
                }
            } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                cachedValue = DOT;
                this.cachedTextures.put(cacheKey, cachedValue);
            } else if (this.canPrerender) {
                class_2960 sprite = iconDefinition.getSprite(variantMapKey);
                boolean isOutlined = iconType == EntityIconDefinition.OUTLINED_SPRITE;
                boolean isFlipped = !isOutlined && iconType != EntityIconDefinition.NORMAL_SPRITE;
                cachedValue = this.prerenderer.prerender(cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, null, sprite, isOutlined, isFlipped, debug);
                this.cachedTextures.put(cacheKey, cachedValue);
                this.canPrerender = false;
            } else {
                cachedValue = null;
            }
        }
        return cachedValue;
    }

    public void reset() {
        this.prerenderer.clearAtlases();
        this.cachedTextures.clear();
        MinimapLogs.LOGGER.info("Entity icon manager reset!");
    }

    public void resetResources() {
        MinimapLogs.LOGGER.info("Reloading entity icon resources...");
        Set entityIds = class_2378.field_11145.method_10235();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        MinimapLogs.LOGGER.info("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResourcesAttempt(Gson gson, Set<class_2960> entityIds) throws IOException {
        this.iconDefinitions.clear();
        for (class_2960 id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            class_3298 resource = null;
            try {
                resource = class_310.method_1551().method_1478().method_14486(new class_2960("xaerominimap", "entity/icon/definition/" + id.method_12836() + "/" + id.method_12832() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.method_14482();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(line -> {
                    stringBuilder.append((String)line);
                    stringBuilder.append('\n');
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                MinimapLogs.LOGGER.error("Json syntax exception when loading the entity icon definition for " + id + ".", (Throwable)jse);
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelRenderDetection(class_583<?> model, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelRenderDetection(model, red, green, blue, alpha);
    }

    public void onModelPartRenderDetection(class_630 modelRenderer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }
}

